/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google;
import autovalue.shaded.com.google$.auto.common.$AnnotationMirrors;
import autovalue.shaded.com.google$.auto.common.$AnnotationValues;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreStreams;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.auto.common.$Visibility;
import autovalue.shaded.com.google$.common.base.$Ascii;
import autovalue.shaded.com.google$.common.base.$VerifyException;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Maps;
import autovalue.shaded.net.ltgt.gradle.incap;
import com.google.auto.value.processor.AutoBuilderTemplateVars;
import com.google.auto.value.processor.AutoValueishProcessor;
import com.google.auto.value.processor.BuilderMethodClassifier;
import com.google.auto.value.processor.BuilderMethodClassifierForAutoBuilder;
import com.google.auto.value.processor.BuilderSpec;
import com.google.auto.value.processor.MissingTypes;
import com.google.auto.value.processor.Reformatter;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeSimplifier;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"com.google.auto.value.AutoBuilder"})
@google..AutoService(value={Processor.class})
@incap..IncrementalAnnotationProcessor(value=incap..IncrementalAnnotationProcessorType.ISOLATING)
public class AutoBuilderProcessor
extends AutoValueishProcessor {
    private static final String ALLOW_OPTION = "com.google.auto.value.AutoBuilderIsUnstable";
    private TypeMirror javaLangVoid;
    private static final ElementKind ELEMENT_KIND_RECORD = AutoBuilderProcessor.elementKindRecord();

    public AutoBuilderProcessor() {
        super("com.google.auto.value.AutoBuilder");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return $ImmutableSet.of("com.google.auto.value.OmitIdentifiers", ALLOW_OPTION);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.javaLangVoid = this.elementUtils().getTypeElement("java.lang.Void").asType();
    }

    @Override
    void processType(TypeElement autoBuilderType) {
        BuilderSpec builderSpec;
        if (!this.processingEnv.getOptions().containsKey(ALLOW_OPTION)) {
            this.errorReporter().abortWithError(autoBuilderType, "Compile with -A%s to enable this UNSUPPORTED AND UNSTABLE prototype", ALLOW_OPTION);
        }
        if (autoBuilderType.getKind() != ElementKind.CLASS && autoBuilderType.getKind() != ElementKind.INTERFACE) {
            this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderWrongType] @AutoBuilder only applies to classes and interfaces", new Object[0]);
        }
        this.checkModifiersIfNested(autoBuilderType);
        AnnotationMirror autoBuilderAnnotation = AutoBuilderProcessor.getAnnotationMirror(autoBuilderType, "com.google.auto.value.AutoBuilder").get();
        TypeElement ofClass = this.getOfClass(autoBuilderType, autoBuilderAnnotation);
        this.checkModifiersIfNested(ofClass, autoBuilderType, "AutoBuilder ofClass");
        String callMethod = this.findCallMethodValue(autoBuilderAnnotation);
        $ImmutableSet<ExecutableElement> methods = AutoBuilderProcessor.abstractMethodsIn($MoreElements.getLocalAndInheritedMethods(autoBuilderType, this.typeUtils(), this.elementUtils()));
        ExecutableElement executable = this.findExecutable(ofClass, callMethod, autoBuilderType, methods);
        BuilderSpec builderSpec2 = builderSpec = new BuilderSpec(ofClass, this.processingEnv, this.errorReporter());
        builderSpec2.getClass();
        BuilderSpec.Builder builder = builderSpec2.new BuilderSpec.Builder(autoBuilderType);
        TypeMirror builtType = this.builtType(executable);
        Optional<BuilderMethodClassifier<VariableElement>> maybeClassifier = BuilderMethodClassifierForAutoBuilder.classify(methods, this.errorReporter(), this.processingEnv, executable, builtType, autoBuilderType);
        if (!maybeClassifier.isPresent()) {
            return;
        }
        BuilderMethodClassifier<VariableElement> classifier = maybeClassifier.get();
        Map<String, String> propertyToGetterName = $Maps.transformValues(classifier.builderGetters(), BuilderSpec.PropertyGetter::getName);
        AutoBuilderTemplateVars vars = new AutoBuilderTemplateVars();
        vars.props = this.propertySet(executable, propertyToGetterName);
        builder.defineVars(vars, classifier);
        vars.identifiers = !this.processingEnv.getOptions().containsKey("com.google.auto.value.OmitIdentifiers");
        String generatedClassName = AutoBuilderProcessor.generatedClassName(autoBuilderType, "AutoBuilder_");
        vars.builderName = TypeSimplifier.simpleNameOf(generatedClassName);
        vars.builtType = TypeEncoder.encode(builtType);
        vars.build = this.build(executable);
        vars.types = this.typeUtils();
        vars.toBuilderConstructor = false;
        vars.toBuilderMethods = $ImmutableList.of();
        this.defineSharedVarsForType(autoBuilderType, $ImmutableSet.of(), vars);
        String text = vars.toText();
        text = TypeEncoder.decode(text, this.processingEnv, vars.pkg, autoBuilderType.asType());
        text = Reformatter.fixup(text);
        this.writeSourceFile(generatedClassName, text, autoBuilderType);
    }

    private $ImmutableSet<AutoValueishProcessor.Property> propertySet(ExecutableElement executable, Map<String, String> propertyToGetterName) {
        Map<VariableElement, String> identifiers = executable.getParameters().stream().collect(Collectors.toMap(v -> v, v -> v.getSimpleName().toString()));
        AutoBuilderProcessor.fixReservedIdentifiers(identifiers);
        return executable.getParameters().stream().map(v -> this.newProperty((VariableElement)v, (String)identifiers.get(v), (String)propertyToGetterName.get(v.getSimpleName().toString()))).collect($MoreStreams.toImmutableSet());
    }

    private AutoValueishProcessor.Property newProperty(VariableElement var, String identifier, String getterName) {
        String name = var.getSimpleName().toString();
        TypeMirror type = var.asType();
        Optional<String> nullableAnnotation = AutoBuilderProcessor.nullableAnnotationFor(var, var.asType());
        return new AutoValueishProcessor.Property(name, identifier, TypeEncoder.encode(type), type, nullableAnnotation, getterName);
    }

    private ExecutableElement findExecutable(TypeElement ofClass, String callMethod, TypeElement autoBuilderType, $ImmutableSet<ExecutableElement> methods) {
        $ImmutableList<ExecutableElement> executables = this.findRelevantExecutables(ofClass, callMethod, autoBuilderType);
        String description = callMethod.isEmpty() ? "constructor" : "static method named \"" + callMethod + "\"";
        switch (executables.size()) {
            case 0: {
                throw this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderNoVisible] No visible %s for %s", description, ofClass);
            }
            case 1: {
                return (ExecutableElement)executables.get(0);
            }
        }
        return this.matchingExecutable(autoBuilderType, executables, methods, description);
    }

    private $ImmutableList<ExecutableElement> findRelevantExecutables(TypeElement ofClass, String callMethod, TypeElement autoBuilderType) {
        List<? extends Element> elements = ofClass.getEnclosedElements();
        Stream relevantExecutables = callMethod.isEmpty() ? ElementFilter.constructorsIn(elements).stream() : ElementFilter.methodsIn(elements).stream().filter(m -> m.getSimpleName().contentEquals(callMethod)).filter(m -> m.getModifiers().contains((Object)Modifier.STATIC));
        return relevantExecutables.filter(c -> this.visibleFrom((Element)c, $MoreElements.getPackage(autoBuilderType))).collect($MoreStreams.toImmutableList());
    }

    private ExecutableElement matchingExecutable(TypeElement autoBuilderType, List<ExecutableElement> executables, $ImmutableSet<ExecutableElement> methods, String description) {
        $ImmutableList matches = executables.stream().filter(x -> this.executableMatches((ExecutableElement)x, methods)).collect($MoreStreams.toImmutableList());
        switch (matches.size()) {
            case 0: {
                throw this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderNoMatch] Property names do not correspond to the parameter names of any %s:\n%s", description, this.executableListString(executables));
            }
            case 1: {
                return (ExecutableElement)matches.get(0);
            }
        }
        int max = matches.stream().mapToInt(c -> c.getParameters().size()).max().getAsInt();
        $ImmutableList<ExecutableElement> maxMatches = matches.stream().filter(c -> c.getParameters().size() == max).collect($MoreStreams.toImmutableList());
        if (maxMatches.size() > 1) {
            throw this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderAmbiguous] Property names correspond to more than one %s:\n%s", description, this.executableListString(maxMatches));
        }
        return (ExecutableElement)maxMatches.get(0);
    }

    private String executableListString(List<ExecutableElement> executables) {
        return executables.stream().map(AutoBuilderProcessor::executableString).collect(Collectors.joining("\n  ", "  ", ""));
    }

    static String executableString(ExecutableElement executable) {
        Element nameSource = executable.getKind() == ElementKind.CONSTRUCTOR ? executable.getEnclosingElement() : executable;
        return nameSource.getSimpleName() + executable.getParameters().stream().map(v -> v.asType() + " " + v.getSimpleName()).collect(Collectors.joining(", ", "(", ")"));
    }

    private boolean executableMatches(ExecutableElement executable, $ImmutableSet<ExecutableElement> methods) {
        NavigableSet parameterNames = executable.getParameters().stream().map(v -> v.getSimpleName().toString()).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
        for (ExecutableElement method : methods) {
            String name = method.getSimpleName().toString();
            if (name.endsWith("Builder")) {
                String property = name.substring(0, name.length() - "Builder".length());
                parameterNames.remove(property);
            }
            if (method.getParameters().size() == 1) {
                parameterNames.remove(name);
                if (name.startsWith("set")) {
                    parameterNames.remove(name.substring(3));
                }
            }
            if (!parameterNames.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean visibleFrom(Element element, PackageElement fromPackage) {
        $Visibility visibility = $Visibility.effectiveVisibilityOfElement(element);
        switch (visibility) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: 
            case DEFAULT: {
                return $MoreElements.getPackage(element).equals(fromPackage);
            }
        }
        return false;
    }

    private TypeMirror builtType(ExecutableElement executable) {
        switch (executable.getKind()) {
            case CONSTRUCTOR: {
                return executable.getEnclosingElement().asType();
            }
            case METHOD: {
                return executable.getReturnType();
            }
        }
        throw new $VerifyException("Unexpected executable kind " + (Object)((Object)executable.getKind()));
    }

    private String build(ExecutableElement executable) {
        TypeElement enclosing = $MoreElements.asType(executable.getEnclosingElement());
        String type = TypeEncoder.encodeRaw(enclosing.asType());
        switch (executable.getKind()) {
            case CONSTRUCTOR: {
                boolean generic = !enclosing.getTypeParameters().isEmpty();
                String typeParams = generic ? "<>" : "";
                return "new " + type + typeParams;
            }
            case METHOD: {
                return type + "." + executable.getSimpleName();
            }
        }
        throw new $VerifyException("Unexpected executable kind " + (Object)((Object)executable.getKind()));
    }

    private static ElementKind elementKindRecord() {
        try {
            Field record = ElementKind.class.getField("RECORD");
            return (ElementKind)((Object)record.get(null));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private TypeElement getOfClass(TypeElement autoBuilderType, AnnotationMirror autoBuilderAnnotation) {
        TypeElement ofClassValue = this.findOfClassValue(autoBuilderAnnotation);
        boolean isDefault = this.typeUtils().isSameType(ofClassValue.asType(), this.javaLangVoid);
        if (!isDefault) {
            return ofClassValue;
        }
        Element enclosing = autoBuilderType.getEnclosingElement();
        ElementKind enclosingKind = enclosing.getKind();
        if (enclosing.getKind() != ElementKind.CLASS && enclosingKind != ELEMENT_KIND_RECORD) {
            this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderEnclosing] @AutoBuilder must specify ofClass=Something.class or it must be nested inside the class to be built; actually nested inside %s %s.", $Ascii.toLowerCase(enclosingKind.name()), enclosing);
        }
        return $MoreElements.asType(enclosing);
    }

    private TypeElement findOfClassValue(AnnotationMirror autoBuilderAnnotation) {
        AnnotationValue ofClassValue = $AnnotationMirrors.getAnnotationValue(autoBuilderAnnotation, "ofClass");
        Object value = ofClassValue.getValue();
        if (value instanceof TypeMirror) {
            TypeMirror ofClassType = (TypeMirror)value;
            switch (ofClassType.getKind()) {
                case DECLARED: {
                    return $MoreTypes.asTypeElement(ofClassType);
                }
                case ERROR: {
                    throw new MissingTypes.MissingTypeException($MoreTypes.asError(ofClassType));
                }
            }
        }
        throw new MissingTypes.MissingTypeException(null);
    }

    private String findCallMethodValue(AnnotationMirror autoBuilderAnnotation) {
        AnnotationValue callMethodValue = $AnnotationMirrors.getAnnotationValue(autoBuilderAnnotation, "callMethod");
        return $AnnotationValues.getString(callMethodValue);
    }

    @Override
    Optional<String> nullableAnnotationForMethod(ExecutableElement propertyMethod) {
        return Optional.empty();
    }
}

