/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;

@BugPattern(summary="Qualifiers/Scope annotations on @Inject methods don't have any effect. Move the qualifier annotation to the binding location.", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public class QualifierOrScopeOnInjectMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final MultiMatcher<MethodTree, AnnotationTree> QUALIFIER_ANNOTATION_FINDER = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{InjectMatchers.IS_BINDING_ANNOTATION, InjectMatchers.IS_SCOPING_ANNOTATION}));
    private static final MultiMatcher<MethodTree, AnnotationTree> HAS_INJECT = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)InjectMatchers.IS_APPLICATION_OF_AT_INJECT);
    private static final Matcher<MethodTree> PROVIDES_METHOD = InjectMatchers.hasProvidesAnnotation();

    public Description matchMethod(MethodTree tree, VisitorState state) {
        MultiMatcher.MultiMatchResult qualifierAnnotations = QUALIFIER_ANNOTATION_FINDER.multiMatchResult((Tree)tree, state);
        MultiMatcher.MultiMatchResult injectAnnotations = HAS_INJECT.multiMatchResult((Tree)tree, state);
        if (!qualifierAnnotations.matches() || !injectAnnotations.matches()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        ImmutableList matchingAnnotations = qualifierAnnotations.matchingNodes();
        if (ASTHelpers.getSymbol((MethodTree)tree).isConstructor()) {
            ArrayList<AnnotationTree> scopes = new ArrayList<AnnotationTree>();
            ArrayList<AnnotationTree> qualifiers = new ArrayList<AnnotationTree>();
            for (AnnotationTree annoTree : matchingAnnotations) {
                (InjectMatchers.IS_SCOPING_ANNOTATION.matches((Tree)annoTree, state) ? scopes : qualifiers).add(annoTree);
            }
            ClassTree outerClass = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
            scopes.forEach(a -> {
                fixBuilder.delete((Tree)a);
                fixBuilder.prefixWith((Tree)outerClass, state.getSourceForNode((Tree)a) + " ");
            });
            QualifierOrScopeOnInjectMethod.deleteAll(qualifiers, fixBuilder);
            return this.describeMatch(tree, (Fix)fixBuilder.build());
        }
        if (PROVIDES_METHOD.matches((Tree)tree, state)) {
            QualifierOrScopeOnInjectMethod.deleteAll((List<AnnotationTree>)injectAnnotations.matchingNodes(), fixBuilder);
            return this.describeMatch((Tree)injectAnnotations.matchingNodes().get(0), (Fix)fixBuilder.build());
        }
        QualifierOrScopeOnInjectMethod.deleteAll((List<AnnotationTree>)matchingAnnotations, fixBuilder);
        return this.describeMatch((Tree)matchingAnnotations.get(0), (Fix)fixBuilder.build());
    }

    private static void deleteAll(List<AnnotationTree> scopes, SuggestedFix.Builder fixBuilder) {
        scopes.forEach(arg_0 -> ((SuggestedFix.Builder)fixBuilder).delete(arg_0));
    }
}

