/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.io.Serializable;
import java.util.Objects;

@BugPattern(summary="String.substring(0) returns the original String", explanation="String.substring(int) gives you the substring from the index to the end, inclusive. Calling that method with an index of 0 will return the same String.", severity=BugPattern.SeverityLevel.ERROR)
public final class SubstringOfZero
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> SUBSTRING_CALLS = Matchers.instanceMethod().onExactClass("java.lang.String").named("substring").withParameters("int", new String[0]);
    private static final Matcher<MethodInvocationTree> ARGUMENT_IS_ZERO = Matchers.argument((int)0, (Matcher & Serializable)(tree, state) -> Objects.equals(ASTHelpers.constValue((Tree)tree), 0));
    private static final Matcher<MethodInvocationTree> SUBSTRING_CALLS_WITH_ZERO_ARG = Matchers.allOf((Matcher[])new Matcher[]{SUBSTRING_CALLS, ARGUMENT_IS_ZERO});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!SUBSTRING_CALLS_WITH_ZERO_ARG.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, SubstringOfZero.removeSubstringCall(tree, state));
    }

    private static Fix removeSubstringCall(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree originalString = ASTHelpers.getReceiver((ExpressionTree)tree);
        return SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)originalString));
    }
}

