/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="Implementing 'Comparable<T>' where T is not the same as the implementing class is incorrect, since it violates the symmetry contract of compareTo.", severity=BugPattern.SeverityLevel.ERROR)
public class ComparableType
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        Type comparableType = state.getSymtab().comparableType;
        return tree.getImplementsClause().stream().filter(impl -> ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)impl), (Type)comparableType, (VisitorState)state)).findAny().map(impl -> this.match(tree, (Tree)impl, state)).orElse(Description.NO_MATCH);
    }

    Description match(ClassTree tree, Tree impl, VisitorState state) {
        Type implType = ASTHelpers.getType((Tree)impl);
        Type.ClassType type = ASTHelpers.getType((ClassTree)tree);
        if (implType.getTypeArguments().isEmpty()) {
            return this.buildDescription(tree).setMessage("Comparable should not be raw").build();
        }
        Type comparableTypeArgument = (Type)Iterables.getOnlyElement(implType.getTypeArguments());
        if (!ASTHelpers.isSameType((Type)type, (Type)comparableTypeArgument, (VisitorState)state)) {
            return this.buildDescription(tree).setMessage(String.format("Type of Comparable (%s) is not the same as implementing class (%s).", Signatures.prettyType((Type)comparableTypeArgument), Signatures.prettyType((Type)type))).build();
        }
        return Description.NO_MATCH;
    }
}

