/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.context;

import com.google.common.flogger.context.ContextDataProvider;
import com.google.common.flogger.context.LogLevelMap;
import com.google.common.flogger.context.ScopedLoggingContext;
import com.google.common.flogger.context.Tags;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

final class NoOpContextDataProvider
extends ContextDataProvider {
    NoOpContextDataProvider() {
    }

    @Override
    public ScopedLoggingContext getContextApiSingleton() {
        return LazyHolder.NO_OP_CONTEXT;
    }

    @Override
    public boolean shouldForceLogging(String loggerName, Level level, boolean isEnabledByLevel) {
        return false;
    }

    @Override
    public Tags getTags() {
        return Tags.empty();
    }

    private static final class NoOpContext
    extends ScopedLoggingContext {
        private final AtomicBoolean haveWarned = new AtomicBoolean();
        private static final Closeable NO_OP_CLOSEABLE = new Closeable(){

            @Override
            public void close() {
            }
        };

        NoOpContext() {
        }

        @Override
        public Closeable withNewScope() {
            if (this.haveWarned.compareAndSet(false, true)) {
                System.err.format("%s#withNewScope() was called, but no implementation of %s was installed.\n\tLogging scopes, and the use of tags or log forcing will have no effect.\n\tSet the system property '%s' to install a %s.", ScopedLoggingContext.class.getName(), ContextDataProvider.class.getName(), "flogger.context", ContextDataProvider.class.getSimpleName());
            }
            return NO_OP_CLOSEABLE;
        }

        @Override
        public boolean applyLogLevelMap(LogLevelMap m) {
            return false;
        }

        @Override
        public boolean addTags(Tags tags) {
            return false;
        }
    }

    private static final class LazyHolder {
        private static final ScopedLoggingContext NO_OP_CONTEXT = new NoOpContext();

        private LazyHolder() {
        }
    }
}

