/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.RuntimeVersion;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

public final class FindIdentifiers {
    public static Symbol findIdent(String name, VisitorState state) {
        return FindIdentifiers.findIdent(name, state, Kinds.KindSelector.VAR);
    }

    @Nullable
    public static Symbol findIdent(String name, VisitorState state, Kinds.KindSelector kind) {
        Env<AttrContext> env;
        Type.ClassType enclosingClass = ASTHelpers.getType(FindIdentifiers.getEnclosingClass(state.getPath()));
        if (enclosingClass == null || enclosingClass.tsym == null) {
            env = Enter.instance(state.context).getTopLevelEnv((JCTree.JCCompilationUnit)state.getPath().getCompilationUnit());
        } else {
            env = Enter.instance(state.context).getClassEnv(enclosingClass.tsym);
            MethodTree enclosingMethod = (MethodTree)state.findEnclosing(MethodTree.class);
            if (enclosingMethod != null) {
                env = MemberEnter.instance(state.context).getMethodEnv((JCTree.JCMethodDecl)enclosingMethod, env);
            }
        }
        try {
            Symbol result = FindIdentifiers.findIdent(name, state, kind, env);
            return result.exists() ? result : null;
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Symbol findIdent(String name, VisitorState state, Kinds.KindSelector kind, Env<AttrContext> env) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (RuntimeVersion.isAtLeast13()) {
            Method method = Resolve.class.getDeclaredMethod("findIdent", JCDiagnostic.DiagnosticPosition.class, Env.class, Name.class, Kinds.KindSelector.class);
            method.setAccessible(true);
            return (Symbol)method.invoke((Object)Resolve.instance(state.context), null, env, state.getName(name), kind);
        }
        Method method = Resolve.class.getDeclaredMethod("findIdent", Env.class, Name.class, Kinds.KindSelector.class);
        method.setAccessible(true);
        return (Symbol)method.invoke((Object)Resolve.instance(state.context), env, state.getName(name), kind);
    }

    @Nullable
    private static ClassTree getEnclosingClass(TreePath treePath) {
        if (treePath.getLeaf() instanceof ClassTree) {
            return (ClassTree)treePath.getLeaf();
        }
        TreePath parent;
        while ((parent = treePath.getParentPath()) != null) {
            Tree leaf = parent.getLeaf();
            if (leaf instanceof ClassTree && ((ClassTree)leaf).getMembers().contains(treePath.getLeaf())) {
                return (ClassTree)leaf;
            }
            treePath = parent;
        }
        return null;
    }

    public static ImmutableSet<Symbol.VarSymbol> findAllIdents(VisitorState state) {
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        Tree prev = state.getPath().getLeaf();
        for (Tree curr : state.getPath().getParentPath()) {
            switch (curr.getKind()) {
                case BLOCK: {
                    StatementTree statementTree;
                    Iterator<Tree> iterator = ((BlockTree)curr).getStatements().iterator();
                    while (iterator.hasNext() && !(statementTree = (StatementTree)iterator.next()).equals(prev)) {
                        FindIdentifiers.addIfVariable(statementTree, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    }
                    break;
                }
                case LAMBDA_EXPRESSION: {
                    for (VariableTree variableTree : ((LambdaExpressionTree)curr).getParameters()) {
                        result.add((Object)ASTHelpers.getSymbol(variableTree));
                    }
                    break;
                }
                case METHOD: {
                    for (VariableTree variableTree : ((MethodTree)curr).getParameters()) {
                        result.add((Object)ASTHelpers.getSymbol(variableTree));
                    }
                    break;
                }
                case CATCH: {
                    result.add((Object)ASTHelpers.getSymbol(((CatchTree)curr).getParameter()));
                    break;
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    for (Tree tree : ((ClassTree)curr).getMembers()) {
                        if (tree.equals(prev)) break;
                        FindIdentifiers.addIfVariable(tree, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    }
                    Type classType = ASTHelpers.getType(curr);
                    List<Type> list = state.getTypes().closure(classType);
                    java.util.List<Type> superTypes = list.size() <= 1 ? Collections.emptyList() : list.subList(1, list.size());
                    for (Type type : superTypes) {
                        Scope.WriteableScope scope = type.tsym.members();
                        ImmutableList.Builder builder = ImmutableList.builder();
                        for (Symbol var : ASTHelpers.scope(scope).getSymbols(Symbol.VarSymbol.class::isInstance)) {
                            builder.add((Object)((Symbol.VarSymbol)var));
                        }
                        result.addAll((Iterable)builder.build().reverse());
                    }
                    break;
                }
                case FOR_LOOP: {
                    FindIdentifiers.addAllIfVariable(((ForLoopTree)curr).getInitializer(), (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    result.add((Object)ASTHelpers.getSymbol(((EnhancedForLoopTree)curr).getVariable()));
                    break;
                }
                case TRY: {
                    TryTree tryTree = (TryTree)curr;
                    boolean inResources = false;
                    for (Tree tree : tryTree.getResources()) {
                        if (!tree.equals(prev)) continue;
                        inResources = true;
                        break;
                    }
                    if (inResources) {
                        for (Tree tree : tryTree.getResources()) {
                            if (tree.equals(prev)) break;
                            FindIdentifiers.addIfVariable(tree, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                        }
                        break;
                    }
                    if (!tryTree.getBlock().equals(prev)) break;
                    FindIdentifiers.addAllIfVariable(tryTree.getResources(), (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    break;
                }
                case COMPILATION_UNIT: {
                    for (ImportTree importTree : ((CompilationUnitTree)curr).getImports()) {
                        if (!importTree.isStatic() || importTree.getQualifiedIdentifier().getKind() != Tree.Kind.MEMBER_SELECT) continue;
                        MemberSelectTree memberSelectTree = (MemberSelectTree)importTree.getQualifiedIdentifier();
                        Scope.CompoundScope scope = state.getTypes().membersClosure(ASTHelpers.getType(memberSelectTree.getExpression()), false);
                        for (Symbol var : ASTHelpers.scope(scope).getSymbols(sym -> sym instanceof Symbol.VarSymbol && sym.getSimpleName().equals(memberSelectTree.getIdentifier()))) {
                            result.add((Object)((Symbol.VarSymbol)var));
                        }
                    }
                    break;
                }
            }
            prev = curr;
        }
        return (ImmutableSet)result.build().stream().filter(variable -> FindIdentifiers.isVisible(variable, state.getPath())).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<Symbol.VarSymbol> findUnusedIdentifiers(VisitorState state) {
        ImmutableSet.Builder definedVariables = ImmutableSet.builder();
        ImmutableSet.Builder usedSymbols = ImmutableSet.builder();
        Tree prev = state.getPath().getLeaf();
        for (Tree curr : state.getPath().getParentPath()) {
            FindIdentifiers.createFindIdentifiersScanner((ImmutableSet.Builder<Symbol>)usedSymbols, prev).scan(curr, null);
            switch (curr.getKind()) {
                case BLOCK: {
                    for (StatementTree statementTree : ((BlockTree)curr).getStatements()) {
                        if (statementTree.equals(prev)) break;
                        FindIdentifiers.addIfVariable(statementTree, (ImmutableSet.Builder<Symbol.VarSymbol>)definedVariables);
                    }
                    break;
                }
                case FOR_LOOP: {
                    ForLoopTree forLoop = (ForLoopTree)curr;
                    forLoop.getInitializer().stream().forEach(t -> FindIdentifiers.addIfVariable(t, (ImmutableSet.Builder<Symbol.VarSymbol>)definedVariables));
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)curr;
                    FindIdentifiers.addIfVariable(enhancedForLoopTree.getVariable(), (ImmutableSet.Builder<Symbol.VarSymbol>)definedVariables);
                    break;
                }
            }
            prev = curr;
        }
        return ImmutableSet.copyOf((Collection)Sets.difference((Set)definedVariables.build(), (Set)usedSymbols.build()));
    }

    public static ImmutableSet<Symbol> findReferencedIdentifiers(Tree tree) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        FindIdentifiers.createFindIdentifiersScanner((ImmutableSet.Builder<Symbol>)builder, null).scan(tree, null);
        return builder.build();
    }

    public static ImmutableList<Symbol.VarSymbol> findAllFields(Type classType, VisitorState state) {
        return (ImmutableList)state.getTypes().closure(classType).stream().flatMap(type -> {
            Symbol.TypeSymbol tsym = type.tsym;
            if (tsym == null) {
                return ImmutableList.of().stream();
            }
            Scope.WriteableScope scope = tsym.members();
            if (scope == null) {
                return ImmutableList.of().stream();
            }
            return ImmutableList.copyOf(ASTHelpers.scope(scope).getSymbols(Symbol.VarSymbol.class::isInstance)).reverse().stream().map(v -> (Symbol.VarSymbol)v).filter(v -> FindIdentifiers.isVisible(v, state.getPath()));
        }).collect(ImmutableList.toImmutableList());
    }

    private static TreeScanner<Void, Void> createFindIdentifiersScanner(final ImmutableSet.Builder<Symbol> builder, final @Nullable Tree stoppingPoint) {
        return new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void unused) {
                return Objects.equals(stoppingPoint, tree) ? null : (Void)super.scan(tree, unused);
            }

            @Override
            public Void scan(Iterable<? extends Tree> iterable, Void unused) {
                if (stoppingPoint != null && iterable != null) {
                    ImmutableList.Builder builder2 = ImmutableList.builder();
                    for (Tree t : iterable) {
                        if (stoppingPoint.equals(t)) break;
                        builder2.add((Object)t);
                    }
                    iterable = builder2.build();
                }
                return (Void)super.scan((Iterable<? extends Tree>)iterable, unused);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol(identifierTree);
                if (symbol != null) {
                    builder.add((Object)symbol);
                }
                return null;
            }
        };
    }

    private static boolean isVisible(Symbol.VarSymbol var, TreePath path) {
        switch (var.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: {
                ImmutableList enclosingClasses = (ImmutableList)StreamSupport.stream(path.spliterator(), false).filter(ClassTree.class::isInstance).map(ClassTree.class::cast).map(ASTHelpers::getSymbol).collect(ImmutableList.toImmutableList());
                if (!var.isStatic()) {
                    if (FindIdentifiers.inStaticContext(path)) {
                        return false;
                    }
                    if (FindIdentifiers.lowerThan(path, (curr, unused) -> {
                        Symbol sym = ASTHelpers.getSymbol(curr);
                        return sym != null && ASTHelpers.isStatic(sym);
                    }, (curr, unused) -> curr instanceof ClassTree && ASTHelpers.getSymbol(curr).equals(var.owner))) {
                        return false;
                    }
                }
                if (enclosingClasses.contains((Object)ASTHelpers.enclosingClass(var))) {
                    return true;
                }
                Symbol.PackageSymbol enclosingPackage = ((JCTree.JCCompilationUnit)path.getCompilationUnit()).packge;
                Set<Modifier> modifiers = var.getModifiers();
                if (Objects.equals(enclosingPackage, ASTHelpers.enclosingPackage(var))) {
                    return !modifiers.contains((Object)Modifier.PRIVATE);
                }
                return modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED);
            }
            case PARAMETER: 
            case LOCAL_VARIABLE: {
                return !FindIdentifiers.lowerThan(path, (curr, parent) -> curr.getKind() == Tree.Kind.LAMBDA_EXPRESSION || curr.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)curr).getClassBody() != null || curr.getKind() == Tree.Kind.CLASS && parent.getKind() == Tree.Kind.BLOCK, (curr, unused) -> Objects.equals(var.owner, ASTHelpers.getSymbol(curr))) || ASTHelpers.isConsideredFinal(var);
            }
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected variable type: " + var.getKind());
    }

    private static boolean inStaticContext(TreePath path) {
        Symbol.ClassSymbol enclosingClass = ASTHelpers.getSymbol(ASTHelpers.findEnclosingNode(path, ClassTree.class));
        Symbol.ClassSymbol directSuperClass = (Symbol.ClassSymbol)enclosingClass.getSuperclass().tsym;
        Tree prev = path.getLeaf();
        path = path.getParentPath();
        for (Tree tree : path) {
            switch (tree.getKind()) {
                case METHOD: {
                    return ASTHelpers.isStatic(ASTHelpers.getSymbol(tree));
                }
                case BLOCK: {
                    if (!((BlockTree)tree).isStatic()) break;
                    return true;
                }
                case VARIABLE: {
                    VariableTree variableTree = (VariableTree)tree;
                    Symbol.VarSymbol variableSym = ASTHelpers.getSymbol(variableTree);
                    if (variableSym.getKind() != ElementKind.FIELD) break;
                    return Objects.equals(variableTree.getInitializer(), prev) && variableSym.isStatic();
                }
                case METHOD_INVOCATION: {
                    Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
                    if (!methodSym.isConstructor() || !Objects.equals(methodSym.owner, enclosingClass) && !Objects.equals(methodSym.owner, directSuperClass)) break;
                    return true;
                }
            }
            prev = tree;
        }
        return false;
    }

    private static void addIfVariable(Tree tree, ImmutableSet.Builder<Symbol.VarSymbol> setBuilder) {
        if (tree.getKind() == Tree.Kind.VARIABLE) {
            setBuilder.add((Object)ASTHelpers.getSymbol((VariableTree)tree));
        }
    }

    private static void addAllIfVariable(java.util.List<? extends Tree> list, ImmutableSet.Builder<Symbol.VarSymbol> setBuilder) {
        for (Tree tree : list) {
            FindIdentifiers.addIfVariable(tree, setBuilder);
        }
    }

    private static boolean lowerThan(TreePath path, BiPredicate<Tree, Tree> predicate1, BiPredicate<Tree, Tree> predicate2) {
        int index1 = -1;
        int index2 = -1;
        int count = 0;
        path = path.getParentPath();
        while (path != null) {
            Tree curr = path.getLeaf();
            TreePath parentPath = path.getParentPath();
            if (index1 < 0 && predicate1.test(curr, parentPath == null ? null : parentPath.getLeaf())) {
                index1 = count;
            }
            if (index2 < 0 && predicate2.test(curr, parentPath == null ? null : parentPath.getLeaf())) {
                index2 = count;
            }
            if (index1 >= 0 && index2 >= 0) break;
            path = parentPath;
            ++count;
        }
        return index1 >= 0 && index1 < index2;
    }

    private FindIdentifiers() {
    }
}

