/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.base.Preconditions;
import com.google.errorprone.dataflow.DataFlow;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.dataflow.nullnesspropagation.TrustingNullnessPropagation;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.Serializable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import org.checkerframework.errorprone.dataflow.analysis.ForwardAnalysisImpl;
import org.checkerframework.errorprone.dataflow.analysis.ForwardTransferFunction;
import org.checkerframework.errorprone.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.errorprone.dataflow.cfg.UnderlyingAST;
import org.checkerframework.errorprone.dataflow.cfg.builder.CFGBuilder;

public final class TrustingNullnessAnalysis
implements Serializable {
    private static final Context.Key<TrustingNullnessAnalysis> TRUSTING_NULLNESS_KEY = new Context.Key();
    private final TrustingNullnessPropagation nullnessPropagation = new TrustingNullnessPropagation();

    public static TrustingNullnessAnalysis instance(Context context) {
        TrustingNullnessAnalysis instance = context.get(TRUSTING_NULLNESS_KEY);
        if (instance == null) {
            instance = new TrustingNullnessAnalysis();
            context.put(TRUSTING_NULLNESS_KEY, instance);
        }
        return instance;
    }

    private TrustingNullnessAnalysis() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Nullness getNullness(TreePath exprPath, Context context) {
        try {
            this.nullnessPropagation.setContext(context).setCompilationUnit(exprPath.getCompilationUnit());
            Nullness nullness = (Nullness)((Object)DataFlow.expressionDataflow(exprPath, context, this.nullnessPropagation));
            return nullness;
        }
        finally {
            this.nullnessPropagation.setContext(null).setCompilationUnit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Nullness getFieldInitializerNullness(TreePath fieldDeclPath, Context context) {
        Tree decl = fieldDeclPath.getLeaf();
        Preconditions.checkArgument((decl instanceof VariableTree && ((JCTree.JCVariableDecl)decl).sym.getKind() == ElementKind.FIELD ? 1 : 0) != 0, (String)"Leaf of fieldDeclPath must be a field declaration: %s", (Object)decl);
        ExpressionTree initializer = ((VariableTree)decl).getInitializer();
        if (initializer == null) {
            return ((JCTree.JCVariableDecl)decl).type.isPrimitive() ? Nullness.NONNULL : Nullness.NULL;
        }
        TreePath initializerPath = TreePath.getPath(fieldDeclPath, (Tree)initializer);
        ClassTree classTree = (ClassTree)fieldDeclPath.getParentPath().getLeaf();
        JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(context);
        UnderlyingAST.CFGStatement ast = new UnderlyingAST.CFGStatement(decl, classTree);
        ControlFlowGraph cfg = CFGBuilder.build((TreePath)initializerPath, (UnderlyingAST)ast, (boolean)false, (boolean)false, (ProcessingEnvironment)javacEnv);
        try {
            this.nullnessPropagation.setContext(context).setCompilationUnit(fieldDeclPath.getCompilationUnit());
            ForwardAnalysisImpl analysis = new ForwardAnalysisImpl((ForwardTransferFunction)this.nullnessPropagation);
            analysis.performAnalysis(cfg);
            Nullness nullness = (Nullness)analysis.getValue((Tree)initializer);
            return nullness;
        }
        finally {
            this.nullnessPropagation.setContext(null).setCompilationUnit(null);
        }
    }

    public static boolean hasNullableAnnotation(Symbol symbol) {
        return NullnessAnnotations.fromAnnotationsOn(symbol).orElse(null) == Nullness.NULLABLE;
    }
}

