// Copyright (c) 1999 Philip A. Hardin (pahardin@cs.utexas.edu)
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License v2 or later.


#include "rendergl.h"

void DrawGL(const xpanel3d& panel, const pt3d viewPts[], const ulong colors[],
            const gfxTarget& gt) {
#ifndef NO_OPENGL
  glIndexi(colors[panel.colorNum]);
  glBegin(GL_POLYGON);
  forii(panel.ptNums.Num() -1) {
    const pt3d& v= viewPts[panel.ptNums[i]];
    glVertex3d(v[0],v[1],v[2]);
  }
  glEnd();
#endif
}

void DrawGL(xregion3d& r, const pt3d viewPts[], const gfxTarget& gt,
            const pt3d& viewPos, const pt2d& clip, bool solid, const ulong colors[]) {
#ifndef NO_OPENGL
  if (solid) {
    r.DrawPolys(viewPts,clip,NULL,0,0,colors,gt,viewPos);
  } else {
    glBegin(GL_LINES);
    forii(r.Edges().Num()) {
      const pt3d& pb= viewPts[r.Edges()[i].beginPtNum];
      const pt3d& pe= viewPts[r.Edges()[i].endPtNum];
      glVertex3d(pb[0],pb[1],pb[2]);
      glVertex3d(pe[0],pe[1],pe[2]);
    }
    glEnd();
  }
#endif
}

