// Copyright (c) 1999 Philip A. Hardin (pahardin@cs.utexas.edu)
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License v2 or later.


#ifndef RECT3D_h
#define RECT3D_h


#include "general.h"
#include "pt3d.h"



/************************************************************************/
struct rect3d {
  pt3d	low,
  	high;

  bool	Contains(const pt3d& p) const
        {return p.IsBetween(low,high);};
  bool	ContainsInclusively(const pt3d& p) const
        {return p.IsBetweenInclusively(low,high);};
  bool	ContainsExclusively(const pt3d& p) const
        {return p.IsBetweenExclusively(low,high);};
//  Center used to return "const pt3d& "
  pt3d	Center() const
        {return (low+high)/2;};

  void	MakeBoundingBox(const table<pt3d>& pts, pt3d::coord& farthestDist) {
    pt3d::coord d;
    
    farthestDist= 0;
    if (pts.Num()==0) {
      low= pt3d(0,0,0);
      high= pt3d(0,0,0);
      return;
    }

    low= pts[0];
    high= pts[0];
    
    forii(pts.Num()) {
      d= (pt3d::coord) pts[i].Dist();
      if (d >farthestDist)
	farthestDist= d;
      low.SetMin(pts[i]);
      high.SetMax(pts[i]);
    }
  };

};


#endif
