/*  $Id: Controller.h,v 1.3 2011/04/16 05:10:57 sarrazip Exp $
    Controller.h - Source of commands from the user.

    batrachians - A robot-killing video game.
    Copyright (C) 2001-2011 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#ifndef _H_Controller
#define _H_Controller

#include <flatzebra/KeyState.h>
#include <flatzebra/Joystick.h>


class Controller
{
public:

    Controller();

    ~Controller();

    void processKey(SDLKey keysym, bool pressed);

    bool isStartRequested() const
    {
        return startKS.justPressed() || joystick.buttonJustPressed(startBI);
    }

    bool isQuitRequested() const
    {
        return quitKS.justPressed();
    }

    bool isRightRequested() const
    {
        return rightKS.isPressed() || joystick.getXAxisDisplacement() > 0;
    }

    bool isLeftRequested() const
    {
        return leftKS.isPressed() || joystick.getXAxisDisplacement() < 0;
    }

    bool isUpRequested() const
    {
        return upKS.isPressed() || joystick.getYAxisDisplacement() < 0;
    }

    bool isDownRequested() const
    {
        return downKS.isPressed() || joystick.getYAxisDisplacement() > 0;
    }

    bool isJumpRequested() const
    {
        return jumpKS.justPressed() || joystick.buttonJustPressed(jumpBI);
    }

    bool isTongueRequested() const
    {
        return tongueKS.justPressed() || joystick.buttonJustPressed(tongueBI);
    }

    bool isFullScreenToggleRequested() const
    {
        return fullScreenKS.justPressed();
    }

    // Must be called once per frame.
    void update();

private:

    flatzebra::KeyState startKS;
    flatzebra::KeyState quitKS;
    flatzebra::KeyState jumpKS;
    flatzebra::KeyState tongueKS;
    flatzebra::KeyState leftKS;
    flatzebra::KeyState rightKS;
    flatzebra::KeyState upKS;
    flatzebra::KeyState downKS;
    flatzebra::KeyState fullScreenKS;
    flatzebra::Joystick joystick;

    // Button indices:
    int startBI;
    int jumpBI;
    int tongueBI;
};


#endif  /* _H_Controller */
