/*  $Id: Controller.cpp,v 1.3 2011/04/16 05:10:57 sarrazip Exp $
    Controller.h - Source of commands from the user.

    batrachians - A robot-killing video game.
    Copyright (C) 2001-2011 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#include "Controller.h"


Controller::Controller()
  : startKS(SDLK_SPACE),
    quitKS(SDLK_ESCAPE),
    jumpKS(SDLK_LCTRL),
    tongueKS(SDLK_LSHIFT),
    leftKS(SDLK_LEFT),
    rightKS(SDLK_RIGHT),
    upKS(SDLK_UP),
    downKS(SDLK_DOWN),
    fullScreenKS(SDLK_F11),
    joystick(),
    startBI(flatzebra::Joystick::START_BTN),
    jumpBI(flatzebra::Joystick::B_BTN),
    tongueBI(flatzebra::Joystick::B_BTN)
{
}


Controller::~Controller()
{
}


void
Controller::processKey(SDLKey keysym, bool pressed)
{
    startKS.check(keysym, pressed);
    quitKS.check(keysym, pressed);
    jumpKS.check(keysym, pressed);
    tongueKS.check(keysym, pressed);
    leftKS.check(keysym, pressed);
    rightKS.check(keysym, pressed);
    upKS.check(keysym, pressed);
    downKS.check(keysym, pressed);
    fullScreenKS.check(keysym, pressed);
}


void
Controller::update()
{
    fullScreenKS.remember();
    startKS.remember();
    jumpKS.remember();
    tongueKS.remember();

    joystick.update();
}
