/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "statsf.h"


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for code member in a statsf_t structure.
 *      Use this function to set code in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      code is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_code        The new value for code
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      statsf_code_t   new_code;
 *
 *      if ( statsf_set_code(&statsf, new_code)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_code(statsf_t *statsf_ptr, statsf_code_t new_code)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->code = new_code;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for row member in a statsf_t structure.
 *      Use this function to set row in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      row is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_row         The new value for row
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      unsigned        new_row;
 *
 *      if ( statsf_set_row(&statsf, new_row)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_row(statsf_t *statsf_ptr, unsigned new_row)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->row = new_row;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for rows member in a statsf_t structure.
 *      Use this function to set rows in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      rows is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_rows        The new value for rows
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      unsigned *      new_rows;
 *
 *      if ( statsf_set_rows(&statsf, new_rows)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_rows(statsf_t *statsf_ptr, unsigned * new_rows)

{
    if ( new_rows == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->rows = new_rows;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for an array element of rows member in a statsf_t
 *      structure. Use this function to set statsf_ptr->rows[c]
 *      in a statsf_t object from non-member functions.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      c               Subscript to the rows array
 *      new_rows_element The new value for rows[c]
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      size_t          c;
 *      unsigned *      new_rows_element;
 *
 *      if ( statsf_set_rows_ae(&statsf, c, new_rows_element)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_ROWS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_rows_ae(statsf_t *statsf_ptr, size_t c, unsigned  new_rows_element)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->rows[c] = new_rows_element;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for rows member in a statsf_t structure.
 *      Use this function to set rows in a statsf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_rows to statsf_ptr->rows.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_rows        The new value for rows
 *      array_size      Size of the rows array.
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      unsigned *      new_rows;
 *      size_t          array_size;
 *
 *      if ( statsf_set_rows_cpy(&statsf, new_rows, array_size)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_ROWS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_rows_cpy(statsf_t *statsf_ptr, unsigned * new_rows, size_t array_size)

{
    if ( new_rows == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    statsf_ptr->rows[c] = new_rows[c];
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for col member in a statsf_t structure.
 *      Use this function to set col in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      col is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_col         The new value for col
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      unsigned        new_col;
 *
 *      if ( statsf_set_col(&statsf, new_col)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_col(statsf_t *statsf_ptr, unsigned new_col)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->col = new_col;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for cols member in a statsf_t structure.
 *      Use this function to set cols in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      cols is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_cols        The new value for cols
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      unsigned *      new_cols;
 *
 *      if ( statsf_set_cols(&statsf, new_cols)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_cols(statsf_t *statsf_ptr, unsigned * new_cols)

{
    if ( new_cols == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->cols = new_cols;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for an array element of cols member in a statsf_t
 *      structure. Use this function to set statsf_ptr->cols[c]
 *      in a statsf_t object from non-member functions.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      c               Subscript to the cols array
 *      new_cols_element The new value for cols[c]
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      size_t          c;
 *      unsigned *      new_cols_element;
 *
 *      if ( statsf_set_cols_ae(&statsf, c, new_cols_element)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_COLS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_cols_ae(statsf_t *statsf_ptr, size_t c, unsigned  new_cols_element)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->cols[c] = new_cols_element;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for cols member in a statsf_t structure.
 *      Use this function to set cols in a statsf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_cols to statsf_ptr->cols.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_cols        The new value for cols
 *      array_size      Size of the cols array.
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      unsigned *      new_cols;
 *      size_t          array_size;
 *
 *      if ( statsf_set_cols_cpy(&statsf, new_cols, array_size)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_COLS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_cols_cpy(statsf_t *statsf_ptr, unsigned * new_cols, size_t array_size)

{
    if ( new_cols == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    statsf_ptr->cols[c] = new_cols[c];
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for sum member in a statsf_t structure.
 *      Use this function to set sum in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      sum is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_sum         The new value for sum
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double          new_sum;
 *
 *      if ( statsf_set_sum(&statsf, new_sum)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_sum(statsf_t *statsf_ptr, double new_sum)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->sum = new_sum;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for nums member in a statsf_t structure.
 *      Use this function to set nums in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      nums is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_nums        The new value for nums
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double *        new_nums;
 *
 *      if ( statsf_set_nums(&statsf, new_nums)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_nums(statsf_t *statsf_ptr, double * new_nums)

{
    if ( new_nums == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->nums = new_nums;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for an array element of nums member in a statsf_t
 *      structure. Use this function to set statsf_ptr->nums[c]
 *      in a statsf_t object from non-member functions.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      c               Subscript to the nums array
 *      new_nums_element The new value for nums[c]
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      size_t          c;
 *      double *        new_nums_element;
 *
 *      if ( statsf_set_nums_ae(&statsf, c, new_nums_element)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_NUMS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_nums_ae(statsf_t *statsf_ptr, size_t c, double  new_nums_element)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->nums[c] = new_nums_element;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for nums member in a statsf_t structure.
 *      Use this function to set nums in a statsf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_nums to statsf_ptr->nums.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_nums        The new value for nums
 *      array_size      Size of the nums array.
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double *        new_nums;
 *      size_t          array_size;
 *
 *      if ( statsf_set_nums_cpy(&statsf, new_nums, array_size)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_NUMS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_nums_cpy(statsf_t *statsf_ptr, double * new_nums, size_t array_size)

{
    if ( new_nums == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    statsf_ptr->nums[c] = new_nums[c];
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for num_count member in a statsf_t structure.
 *      Use this function to set num_count in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      num_count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_num_count   The new value for num_count
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      size_t          new_num_count;
 *
 *      if ( statsf_set_num_count(&statsf, new_num_count)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_num_count(statsf_t *statsf_ptr, size_t new_num_count)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->num_count = new_num_count;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for array_size member in a statsf_t structure.
 *      Use this function to set array_size in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_array_size  The new value for array_size
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      size_t          new_array_size;
 *
 *      if ( statsf_set_array_size(&statsf, new_array_size)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_array_size(statsf_t *statsf_ptr, size_t new_array_size)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->array_size = new_array_size;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for partitions member in a statsf_t structure.
 *      Use this function to set partitions in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      partitions is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_partitions  The new value for partitions
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      unsigned        new_partitions;
 *
 *      if ( statsf_set_partitions(&statsf, new_partitions)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_partitions(statsf_t *statsf_ptr, unsigned new_partitions)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->partitions = new_partitions;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for sum_x member in a statsf_t structure.
 *      Use this function to set sum_x in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      sum_x is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_sum_x       The new value for sum_x
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double          new_sum_x;
 *
 *      if ( statsf_set_sum_x(&statsf, new_sum_x)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_sum_x(statsf_t *statsf_ptr, double new_sum_x)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->sum_x = new_sum_x;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for sum_x_2 member in a statsf_t structure.
 *      Use this function to set sum_x_2 in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      sum_x_2 is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_sum_x_2     The new value for sum_x_2
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double          new_sum_x_2;
 *
 *      if ( statsf_set_sum_x_2(&statsf, new_sum_x_2)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_sum_x_2(statsf_t *statsf_ptr, double new_sum_x_2)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->sum_x_2 = new_sum_x_2;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for row_sums member in a statsf_t structure.
 *      Use this function to set row_sums in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      row_sums is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_row_sums    The new value for row_sums
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double *        new_row_sums;
 *
 *      if ( statsf_set_row_sums(&statsf, new_row_sums)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_row_sums(statsf_t *statsf_ptr, double * new_row_sums)

{
    if ( new_row_sums == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->row_sums = new_row_sums;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for an array element of row_sums member in a statsf_t
 *      structure. Use this function to set statsf_ptr->row_sums[c]
 *      in a statsf_t object from non-member functions.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      c               Subscript to the row_sums array
 *      new_row_sums_element The new value for row_sums[c]
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      size_t          c;
 *      double *        new_row_sums_element;
 *
 *      if ( statsf_set_row_sums_ae(&statsf, c, new_row_sums_element)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_ROW_SUMS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_row_sums_ae(statsf_t *statsf_ptr, size_t c, double  new_row_sums_element)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->row_sums[c] = new_row_sums_element;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for row_sums member in a statsf_t structure.
 *      Use this function to set row_sums in a statsf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_row_sums to statsf_ptr->row_sums.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_row_sums    The new value for row_sums
 *      array_size      Size of the row_sums array.
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double *        new_row_sums;
 *      size_t          array_size;
 *
 *      if ( statsf_set_row_sums_cpy(&statsf, new_row_sums, array_size)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_ROW_SUMS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_row_sums_cpy(statsf_t *statsf_ptr, double * new_row_sums, size_t array_size)

{
    if ( new_row_sums == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    statsf_ptr->row_sums[c] = new_row_sums[c];
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for col_sums member in a statsf_t structure.
 *      Use this function to set col_sums in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      col_sums is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_col_sums    The new value for col_sums
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double *        new_col_sums;
 *
 *      if ( statsf_set_col_sums(&statsf, new_col_sums)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_col_sums(statsf_t *statsf_ptr, double * new_col_sums)

{
    if ( new_col_sums == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->col_sums = new_col_sums;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for an array element of col_sums member in a statsf_t
 *      structure. Use this function to set statsf_ptr->col_sums[c]
 *      in a statsf_t object from non-member functions.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      c               Subscript to the col_sums array
 *      new_col_sums_element The new value for col_sums[c]
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      size_t          c;
 *      double *        new_col_sums_element;
 *
 *      if ( statsf_set_col_sums_ae(&statsf, c, new_col_sums_element)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_COL_SUMS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_col_sums_ae(statsf_t *statsf_ptr, size_t c, double  new_col_sums_element)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->col_sums[c] = new_col_sums_element;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for col_sums member in a statsf_t structure.
 *      Use this function to set col_sums in a statsf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_col_sums to statsf_ptr->col_sums.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_col_sums    The new value for col_sums
 *      array_size      Size of the col_sums array.
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double *        new_col_sums;
 *      size_t          array_size;
 *
 *      if ( statsf_set_col_sums_cpy(&statsf, new_col_sums, array_size)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_COL_SUMS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_col_sums_cpy(statsf_t *statsf_ptr, double * new_col_sums, size_t array_size)

{
    if ( new_col_sums == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    statsf_ptr->col_sums[c] = new_col_sums[c];
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for expected_mean member in a statsf_t structure.
 *      Use this function to set expected_mean in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      expected_mean is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_expected_mean The new value for expected_mean
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double          new_expected_mean;
 *
 *      if ( statsf_set_expected_mean(&statsf, new_expected_mean)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_expected_mean(statsf_t *statsf_ptr, double new_expected_mean)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->expected_mean = new_expected_mean;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for sum_y member in a statsf_t structure.
 *      Use this function to set sum_y in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      sum_y is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_sum_y       The new value for sum_y
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double          new_sum_y;
 *
 *      if ( statsf_set_sum_y(&statsf, new_sum_y)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_sum_y(statsf_t *statsf_ptr, double new_sum_y)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->sum_y = new_sum_y;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for sum_y_2 member in a statsf_t structure.
 *      Use this function to set sum_y_2 in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      sum_y_2 is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_sum_y_2     The new value for sum_y_2
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double          new_sum_y_2;
 *
 *      if ( statsf_set_sum_y_2(&statsf, new_sum_y_2)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_sum_y_2(statsf_t *statsf_ptr, double new_sum_y_2)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->sum_y_2 = new_sum_y_2;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for sum_x_y member in a statsf_t structure.
 *      Use this function to set sum_x_y in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      sum_x_y is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_sum_x_y     The new value for sum_x_y
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      double          new_sum_x_y;
 *
 *      if ( statsf_set_sum_x_y(&statsf, new_sum_x_y)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_sum_x_y(statsf_t *statsf_ptr, double new_sum_x_y)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->sum_x_y = new_sum_x_y;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for tmp_file member in a statsf_t structure.
 *      Use this function to set tmp_file in a statsf_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      tmp_file is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_tmp_file    The new value for tmp_file
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      FILE *          new_tmp_file;
 *
 *      if ( statsf_set_tmp_file(&statsf, new_tmp_file)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_tmp_file(statsf_t *statsf_ptr, FILE * new_tmp_file)

{
    if ( new_tmp_file == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->tmp_file = new_tmp_file;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for an array element of tmp_file member in a statsf_t
 *      structure. Use this function to set statsf_ptr->tmp_file[c]
 *      in a statsf_t object from non-member functions.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      c               Subscript to the tmp_file array
 *      new_tmp_file_element The new value for tmp_file[c]
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      size_t          c;
 *      FILE *          new_tmp_file_element;
 *
 *      if ( statsf_set_tmp_file_ae(&statsf, c, new_tmp_file_element)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_TMP_FILE_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_tmp_file_ae(statsf_t *statsf_ptr, size_t c, FILE  new_tmp_file_element)

{
    if ( false )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	statsf_ptr->tmp_file[c] = new_tmp_file_element;
	return STATSF_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for tmp_file member in a statsf_t structure.
 *      Use this function to set tmp_file in a statsf_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_tmp_file to statsf_ptr->tmp_file.
 *
 *  Arguments:
 *      statsf_ptr      Pointer to the structure to set
 *      new_tmp_file    The new value for tmp_file
 *      array_size      Size of the tmp_file array.
 *
 *  Returns:
 *      STATSF_DATA_OK if the new value is acceptable and assigned
 *      STATSF_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_t        statsf;
 *      FILE *          new_tmp_file;
 *      size_t          array_size;
 *
 *      if ( statsf_set_tmp_file_cpy(&statsf, new_tmp_file, array_size)
 *              == STATSF_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_SET_TMP_FILE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf.h
 ***************************************************************************/

int     statsf_set_tmp_file_cpy(statsf_t *statsf_ptr, FILE * new_tmp_file, size_t array_size)

{
    if ( new_tmp_file == NULL )
	return STATSF_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    statsf_ptr->tmp_file[c] = new_tmp_file[c];
	return STATSF_DATA_OK;
    }
}
