/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "statsf-list.h"


/***************************************************************************
 *  Library:
 *      #include <statsf-list.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for count member in a statsf_list_t structure.
 *      Use this function to set count in a statsf_list_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      statsf_list_ptr Pointer to the structure to set
 *      new_count       The new value for count
 *
 *  Returns:
 *      STATSF_LIST_DATA_OK if the new value is acceptable and assigned
 *      STATSF_LIST_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_list_t   statsf_list;
 *      unsigned        new_count;
 *
 *      if ( statsf_list_set_count(&statsf_list, new_count)
 *              == STATSF_LIST_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf-list.h
 ***************************************************************************/

int     statsf_list_set_count(statsf_list_t *statsf_list_ptr, unsigned new_count)

{
    if ( false )
	return STATSF_LIST_DATA_OUT_OF_RANGE;
    else
    {
	statsf_list_ptr->count = new_count;
	return STATSF_LIST_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf-list.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for an array element of functions member in a statsf_list_t
 *      structure. Use this function to set statsf_list_ptr->functions[c]
 *      in a statsf_list_t object from non-member functions.
 *
 *  Arguments:
 *      statsf_list_ptr Pointer to the structure to set
 *      c               Subscript to the functions array
 *      new_functions_element The new value for functions[c]
 *
 *  Returns:
 *      STATSF_LIST_DATA_OK if the new value is acceptable and assigned
 *      STATSF_LIST_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_list_t   statsf_list;
 *      size_t          c;
 *      statsf_t        new_functions_element;
 *
 *      if ( statsf_list_set_functions_ae(&statsf_list, c, new_functions_element)
 *              == STATSF_LIST_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_LIST_SET_FUNCTIONS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf-list.h
 ***************************************************************************/

int     statsf_list_set_functions_ae(statsf_list_t *statsf_list_ptr, size_t c, statsf_t new_functions_element)

{
    if ( false )
	return STATSF_LIST_DATA_OUT_OF_RANGE;
    else
    {
	statsf_list_ptr->functions[c] = new_functions_element;
	return STATSF_LIST_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <statsf-list.h>
 *      -lbasic-stats -lxtend
 *
 *  Description:
 *      Mutator for functions member in a statsf_list_t structure.
 *      Use this function to set functions in a statsf_list_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_functions to statsf_list_ptr->functions.
 *
 *  Arguments:
 *      statsf_list_ptr Pointer to the structure to set
 *      new_functions   The new value for functions
 *      array_size      Size of the functions array.
 *
 *  Returns:
 *      STATSF_LIST_DATA_OK if the new value is acceptable and assigned
 *      STATSF_LIST_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      statsf_list_t   statsf_list;
 *      statsf_t        new_functions;
 *      size_t          array_size;
 *
 *      if ( statsf_list_set_functions_cpy(&statsf_list, new_functions, array_size)
 *              == STATSF_LIST_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      STATSF_LIST_SET_FUNCTIONS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-06-11  gen-get-set Auto-generated from statsf-list.h
 ***************************************************************************/

int     statsf_list_set_functions_cpy(statsf_list_t *statsf_list_ptr, statsf_t new_functions[], size_t array_size)

{
    if ( new_functions == NULL )
	return STATSF_LIST_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    statsf_list_ptr->functions[c] = new_functions[c];
	return STATSF_LIST_DATA_OK;
    }
}
