/* autogenerated file by ./create_queryfiles.sh */
/* check-sources:disable-copyright-check */

const char *BareosDbSqlite::query_definitions[] = {
/* 0001_get_restore_objects */
"SELECT JobId, ObjectLength, ObjectFullLength, ObjectIndex, ObjectType, ObjectCompression, FileIndex, ObjectName, RestoreObject, PluginName "
  "FROM RestoreObject "
 "WHERE JobId IN (%s) "
   "AND ObjectType = %d "
 "ORDER BY ObjectIndex ASC "
,

/* 0002_cleanup_created_job */
"UPDATE Job "
   "SET JobStatus = 'f', StartTime = SchedTime, EndTime = SchedTime "
 "WHERE JobStatus = 'C' "
,

/* 0003_cleanup_running_job */
"UPDATE Job "
   "SET JobStatus = 'f', EndTime = StartTime "
 "WHERE JobStatus = 'R' "
,

/* 0004_fill_jobhisto */
"INSERT INTO JobHisto ( "
	       "JobId, Job, Name, Type, Level, ClientId, JobStatus, SchedTime, StartTime, EndTime, RealEndTime, JobTDate, "
	       "VolSessionId, VolSessionTime, JobFiles, JobBytes, ReadBytes, JobErrors, JobMissingFiles, PoolId, FileSetId, "
	       "PriorJobId, PurgedFiles, "
	       "HasBase, Reviewed, Comment "
       ") "
"SELECT JobId, Job, Name, Type, Level, ClientId, JobStatus, SchedTime, StartTime, EndTime, RealEndTime, JobTDate, VolSessionId, "
       "VolSessionTime, JobFiles, JobBytes, ReadBytes, JobErrors, JobMissingFiles, PoolId, FileSetId, PriorJobId, PurgedFiles, "
       "HasBase, "
       "Reviewed, Comment "
  "FROM Job "
 "WHERE JobStatus IN ('T','W','f','A','E') "
   "AND NOT EXISTS ( "
		"SELECT JobHisto.JobId "
		  "FROM JobHisto "
		 "WHERE JobHisto.Jobid = Job.JobId "
       ") "
   "AND JobTDate       < %s "
,

/* 0005_list_pool */
"SELECT * "
  "FROM Pool "
 "WHERE PoolId = %s "
,

/* 0006_list_jobs */
"SELECT DISTINCT Job.JobId,Job.Name, Client.Name as Client, "
"Job.StartTime,Job.Type,Job.Level,Job.JobFiles,Job.JobBytes,Job.JobStatus "
"FROM Job "
"LEFT JOIN Client ON Client.ClientId=Job.ClientId "
"LEFT JOIN JobMedia ON JobMedia.JobId=Job.JobId "
"LEFT JOIN Media ON JobMedia.MediaId=Media.MediaId "
"LEFT JOIN FileSet ON FileSet.FileSetId=Job.FileSetId "
"WHERE Job.JobId > 0 "
"%s "
"ORDER BY StartTime%s; "
,

/* 0007_list_jobs_long */
"SELECT DISTINCT Job.JobId, Job.Job, Job.Name, Job.PurgedFiles, Job.Type, Job.Level, "
"Job.ClientId, Client.Name as Client, Job.JobStatus, Job.SchedTime, Job.StartTime, "
"Job.EndTime, Job.RealEndTime, Job.JobTDate, Job.VolSessionId, Job.VolSessionTime, "
"Job.JobFiles, Job.JobBytes, Job.JobErrors, Job.JobMissingFiles, Job.PoolId, "
"Pool.Name as PoolName, Job.PriorJobId, Job.FileSetId, FileSet.FileSet "
"FROM Job "
"LEFT JOIN Client ON Client.ClientId=Job.ClientId "
"LEFT JOIN Pool ON Pool.PoolId=Job.PoolId "
"LEFT JOIN JobMedia ON JobMedia.JobId=Job.JobId "
"LEFT JOIN Media ON JobMedia.MediaId=Media.MediaId "
"LEFT JOIN FileSet ON FileSet.FileSetId=Job.FileSetId "
"WHERE Job.JobId > 0 "
"%s "
"ORDER BY StartTime%s; "
,

/* 0008_list_jobs_count */
"SELECT DISTINCT COUNT(DISTINCT Job.JobId) as count "
"FROM Job "
"LEFT JOIN Client ON Client.ClientId=Job.ClientId "
"LEFT JOIN JobMedia ON JobMedia.JobId=Job.JobId "
"LEFT JOIN Media ON JobMedia.MediaId=Media.MediaId "
"LEFT JOIN FileSet ON FileSet.FileSetId=Job.FileSetId "
"WHERE Job.JobId > 0 "
"%s "
"%s; "
,

/* 0009_list_jobs_last */
"SELECT DISTINCT Job.JobId,Job.Name, Client.Name as Client, "
"Job.StartTime,Job.Type,Job.Level,Job.JobFiles,Job.JobBytes,Job.JobStatus "
"FROM Job "
"LEFT JOIN Client ON Client.ClientId=Job.ClientId "
"LEFT JOIN JobMedia ON JobMedia.JobId=Job.JobId "
"LEFT JOIN Media ON JobMedia.MediaId=Media.MediaId "
"LEFT JOIN FileSet ON FileSet.FileSetId=Job.FileSetId "
"INNER JOIN ( "
   "SELECT MAX(Job.JobId) as MaxJobId "
   "FROM Job "
   "LEFT JOIN Client ON Client.ClientId=Job.ClientId "
   "LEFT JOIN Pool ON Pool.PoolId=Job.PoolId "
   "LEFT JOIN JobMedia ON JobMedia.JobId=Job.JobId "
   "LEFT JOIN Media ON JobMedia.MediaId=Media.MediaId "
   "LEFT JOIN FileSet ON FileSet.FileSetId=Job.FileSetId "
   "WHERE Job.JobId > 0 "
   "%s "
   "GROUP BY Job.Name "
") LastJob "
"ON Job.JobId = LastJob.MaxJobId "
"ORDER BY StartTime%s; "
,

/* 0010_list_jobs_long_last */
"SELECT DISTINCT Job.JobId, Job.Job, Job.Name, Job.PurgedFiles, Job.Type, Job.Level, "
"Job.ClientId, Client.Name as Client, Job.JobStatus, Job.SchedTime, Job.StartTime, "
"Job.EndTime, Job.RealEndTime, Job.JobTDate, Job.VolSessionId, Job.VolSessionTime, "
"Job.JobFiles, Job.JobBytes, Job.JobErrors, Job.JobMissingFiles, Job.PoolId, "
"Pool.Name as PoolName, Job.PriorJobId, Job.FileSetId, FileSet.FileSet "
"FROM Job "
"LEFT JOIN Client ON Client.ClientId=Job.ClientId "
"LEFT JOIN Pool ON Pool.PoolId=Job.PoolId "
"LEFT JOIN JobMedia ON JobMedia.JobId=Job.JobId "
"LEFT JOIN Media ON JobMedia.MediaId=Media.MediaId "
"LEFT JOIN FileSet ON FileSet.FileSetId=Job.FileSetId "
"INNER JOIN ( "
   "SELECT MAX(Job.JobId) as MaxJobId "
   "FROM Job "
   "LEFT JOIN Client ON Client.ClientId=Job.ClientId "
   "LEFT JOIN Pool ON Pool.PoolId=Job.PoolId "
   "LEFT JOIN JobMedia ON JobMedia.JobId=Job.JobId "
   "LEFT JOIN Media ON JobMedia.MediaId=Media.MediaId "
   "LEFT JOIN FileSet ON FileSet.FileSetId=Job.FileSetId "
   "WHERE Job.JobId > 0 "
   "%s "
   "GROUP BY Job.Name "
") LastJob "
"ON Job.JobId = LastJob.MaxJobId "
"ORDER BY StartTime%s; "
,

/* 0011_sel_JobMedia */
"SELECT DISTINCT JobMedia.JobId "
  "FROM JobMedia, Job "
 "WHERE MediaId      = %s "
   "AND Job.JobId    = JobMedia.JobId "
   "AND Job.JobTDate < %s "
,

/* 0012_drop_deltabs */
"DROP TABLE DelCandidates "
,

/* 0013_create_deltabs */
"CREATE TEMPORARY TABLE "
       "DelCandidates ( "
          "JobId INTEGER UNSIGNED NOT NULL, PurgedFiles TINYINT, FileSetId INTEGER UNSIGNED, JobFiles INTEGER UNSIGNED, JobStatus "
          "CHAR "
       ") "
,

/* 0014_create_delindex */
"CREATE INDEX DelInx1 ON DelCandidates (JobId) "
,

/* 0015_uar_count_files */
"SELECT JobFiles "
  "FROM Job "
 "WHERE JobId = %s "
,

/* 0016_uar_list_jobs */
"SELECT JobId, Client.Name as Client, StartTime, Level as JobLevel, JobFiles, JobBytes "
  "FROM Client, Job "
 "WHERE Client.ClientId = Job.ClientId "
   "AND JobStatus IN ('T','W') "
   "AND Type            = 'B' "
 "ORDER BY StartTime DESC LIMIT 20 "
,

/* 0017_uar_print_jobs */
"SELECT DISTINCT JobId, Level, JobFiles, JobBytes, StartTime, VolumeName "
  "FROM Job "
  "JOIN JobMedia "
 "USING (JobId) "
  "JOIN Media "
 "USING (MediaId) "
 "WHERE JobId IN (%s) "
 "ORDER BY StartTime ASC "
,

/* 0018_uar_del_temp */
"DROP TABLE temp "
,

/* 0019_uar_del_temp1 */
"DROP TABLE temp1 "
,

/* 0020_uar_last_full */
"INSERT INTO temp1 "
"SELECT Job.JobId, JobTdate "
  "FROM Job, JobMedia, Media, FileSet "
 "WHERE Job.ClientId     = %s "
   "AND Job.StartTime    < '%s' "
   "AND Level            = 'F' "
   "AND JobStatus IN ('T','W') "
   "AND Type             = 'B' "
   "AND JobMedia.JobId   = Job.JobId "
   "AND Media.Enabled    = 1 "
   "AND JobMedia.MediaId = Media.MediaId "
   "AND Job.FileSetId    = FileSet.FileSetId "
   "AND FileSet.FileSet  = '%s' %s "
 "ORDER BY Job.JobTDate DESC LIMIT 1 "
,

/* 0021_uar_last_full_no_pool */
"INSERT INTO temp1 "
"SELECT Job.JobId, JobTdate "
  "FROM Job, FileSet "
 "WHERE Job.ClientId    = %s "
   "AND Job.StartTime   < '%s' "
   "AND Level           = 'F' "
   "AND JobStatus IN ('T','W') "
   "AND Type            = 'B' "
   "AND Job.FileSetId   = FileSet.FileSetId "
   "AND FileSet.FileSet = '%s' "
 "ORDER BY Job.JobTDate DESC LIMIT 1 "
,

/* 0022_uar_full */
"INSERT INTO temp "
"SELECT Job.JobId, Job.JobTDate, Job.ClientId, Job.Level, Job.JobFiles, Job.JobBytes, StartTime, VolumeName, JobMedia.StartFile, "
       "VolSessionId, VolSessionTime "
  "FROM temp1, Job, JobMedia, Media "
 "WHERE temp1.JobId      = Job.JobId "
   "AND Level            = 'F' "
   "AND JobStatus IN ('T','W') "
   "AND Type             = 'B' "
   "AND Media.Enabled    = 1 "
   "AND JobMedia.JobId   = Job.JobId "
   "AND JobMedia.MediaId = Media.MediaId "
,

/* 0023_uar_dif */
"INSERT INTO temp "
"SELECT Job.JobId, Job.JobTDate, Job.ClientId, Job.Level, Job.JobFiles, Job.JobBytes, Job.StartTime, Media.VolumeName, "
       "JobMedia.StartFile, Job.VolSessionId, Job.VolSessionTime "
  "FROM Job, JobMedia, Media, FileSet "
 "WHERE Job.JobTDate     > %s "
   "AND Job.StartTime    < '%s' "
   "AND Job.ClientId     = %s "
   "AND JobMedia.JobId   = Job.JobId "
   "AND Media.Enabled    = 1 "
   "AND JobMedia.MediaId = Media.MediaId "
   "AND Job.Level        = 'D' "
   "AND JobStatus IN ('T','W') "
   "AND Type             = 'B' "
   "AND Job.FileSetId    = FileSet.FileSetId "
   "AND FileSet.FileSet  = '%s' %s "
 "ORDER BY Job.JobTDate DESC LIMIT 1 "
,

/* 0024_uar_inc */
"INSERT INTO temp "
"SELECT Job.JobId, Job.JobTDate, Job.ClientId, Job.Level, Job.JobFiles, Job.JobBytes, Job.StartTime, Media.VolumeName, "
       "JobMedia.StartFile, Job.VolSessionId, Job.VolSessionTime "
  "FROM Job, JobMedia, Media, FileSet "
 "WHERE Job.JobTDate     > %s "
   "AND Job.StartTime    < '%s' "
   "AND Job.ClientId     = %s "
   "AND Media.Enabled    = 1 "
   "AND JobMedia.JobId   = Job.JobId "
   "AND JobMedia.MediaId = Media.MediaId "
   "AND Job.Level        = 'I' "
   "AND JobStatus IN ('T','W') "
   "AND Type             = 'B' "
   "AND Job.FileSetId    = FileSet.FileSetId "
   "AND FileSet.FileSet  = '%s' %s "
,

/* 0025_uar_list_jobs_by_idlist */
"SELECT DISTINCT Job.JobId, Job.Level, Job.JobFiles, Job.JobBytes, Job.StartTime, Media.VolumeName "
  "FROM Job, JobMedia, Media "
 "WHERE Job.JobId IN (%s) "
   "AND JobMedia.JobId   = Job.JobId "
   "AND Media.Enabled    = 1 "
   "AND JobMedia.MediaId = Media.MediaId "
 "ORDER BY StartTime ASC "
,

/* 0026_uar_sel_jobid_temp */
"SELECT DISTINCT JobId, StartTime "
  "FROM temp "
 "ORDER BY StartTime ASC "
,

/* 0027_uar_sel_all_temp1 */
"SELECT * "
  "FROM temp1 "
,

/* 0028_uar_sel_all_temp */
"SELECT * "
  "FROM temp "
,

/* 0029_uar_sel_fileset */
"SELECT DISTINCT FileSet.FileSet "
  "FROM Job, Client, FileSet "
 "WHERE Job.FileSetId   = FileSet.FileSetId "
   "AND Job.ClientId    = %s "
   "AND Client.ClientId = %s "
 "ORDER BY FileSet.FileSet "
,

/* 0030_uar_sel_filesetid */
"SELECT MAX(FileSet.FileSetId) "
  "FROM FileSet "
  "JOIN Job "
 "USING (FileSetId) "
 "WHERE Job.ClientId = %s "
 "GROUP BY FileSet "
,

/* 0031_uar_jobid_fileindex */
"SELECT Job.JobId, "
       "File.FileIndex "
"FROM Job, "
     "File, "
     "Path, "
     "Client "
"WHERE Job.JobId=File.JobId "
  "AND Job.StartTime<='%s' "
  "AND Path.Path='%s' "
  "AND File.Name='%s' "
  "AND Client.Name='%s' "
  "AND Job.ClientId=Client.ClientId "
  "AND Path.PathId=File.PathId "
  "AND JobStatus IN ('T', "
                    "'W') "
  "AND TYPE='B' "
"ORDER BY Job.StartTime DESC "
"LIMIT 1 "
,

/* 0032_uar_jobids_fileindex */
"SELECT Job.JobId, "
       "File.FileIndex "
"FROM Job, "
     "File, "
     "Path, "
     "Client "
"WHERE Job.JobId IN (%s) "
  "AND Job.JobId=File.JobId "
  "AND Job.StartTime<='%s' "
  "AND Path.Path='%s' "
  "AND File.Name='%s' "
  "AND Client.Name='%s' "
  "AND Job.ClientId=Client.ClientId "
  "AND Path.PathId=File.PathId "
"ORDER BY Job.StartTime DESC "
"LIMIT 1 "
,

/* 0033_uar_jobid_fileindex_from_table */
"SELECT JobId, FileIndex "
  "FROM %s "
 "ORDER BY JobId, FileIndex ASC "
,

/* 0034_select_recent_version_with_basejob */
"SELECT FileId, "
       "Job.JobId AS JobId, "
       "FileIndex, "
       "File.PathId AS PathId, "
       "File.Name AS Name, "
       "LStat, "
       "MD5, "
       "DeltaSeq, "
       "Fhinfo, "
       "Fhnode, "
       "Job.JobTDate AS JobTDate "
"FROM Job, "
     "File, "
  "(SELECT MAX(JobTDate) AS JobTDate, "
          "PathId, "
          "FileName "
   "FROM "
     "(SELECT JobTDate, "
             "PathId, "
             "File.Name AS FileName "
      "FROM File "
      "JOIN Job USING (JobId) "
      "WHERE File.JobId IN (%s) "
        "UNION ALL "
        "SELECT JobTDate, "
               "PathId, "
               "File.Name AS FileName "
        "FROM BaseFiles "
        "JOIN File USING (FileId) "
        "JOIN Job ON (BaseJobId = Job.JobId) WHERE BaseFiles.JobId IN (%s) ) AS tmp "
   "GROUP BY PathId, "
            "FileName) AS T1 "
"WHERE (Job.JobId IN "
         "(SELECT DISTINCT BaseJobId "
          "FROM BaseFiles "
          "WHERE JobId IN (%s)) "
       "OR Job.JobId IN (%s)) "
  "AND T1.JobTDate = Job.JobTDate "
  "AND Job.JobId = File.JobId "
  "AND T1.PathId = File.PathId "
  "AND T1.FileName = File.Name "
,

/* 0035_select_recent_version_with_basejob_and_delta */
"SELECT FileId, "
       "Job.JobId AS JobId, "
       "FileIndex, "
       "File.PathId AS PathId, "
       "File.Name AS Name, "
       "LStat, "
       "MD5, "
       "File.DeltaSeq AS DeltaSeq, "
       "File.Fhinfo AS Fhinfo, "
       "File.Fhnode AS Fhnode, "
       "Job.JobTDate AS JobTDate "
"FROM Job, "
     "File, "
  "( SELECT MAX(JobTDate) AS JobTDate, "
           "PathId, "
           "FileName, "
           "DeltaSeq, "
           "Fhinfo, "
           "Fhnode "
   "FROM "
     "( SELECT JobTDate, "
              "PathId, "
              "File.Name AS FileName, "
              "DeltaSeq, "
              "Fhinfo, "
              "Fhnode "
      "FROM File "
      "JOIN Job USING (JobId) "
      "WHERE File.JobId IN (%s) "
        "UNION ALL "
        "SELECT JobTDate, "
               "PathId, "
               "File.Name AS FileName, "
               "DeltaSeq, "
               "Fhinfo, "
               "Fhnode "
        "FROM BaseFiles "
        "JOIN File USING (FileId) "
        "JOIN Job ON (BaseJobId = Job.JobId) WHERE BaseFiles.JobId IN (%s) ) AS tmp "
   "GROUP BY PathId, "
            "FileName, "
            "DeltaSeq, "
            "Fhinfo, "
            "Fhnode) AS T1 "
"WHERE (Job.JobId IN "
         "(SELECT DISTINCT BaseJobId "
          "FROM BaseFiles "
          "WHERE JobId IN (%s)) "
       "OR Job.JobId IN (%s)) "
  "AND T1.JobTDate = Job.JobTDate "
  "AND Job.JobId = File.JobId "
  "AND T1.PathId = File.PathId "
  "AND T1.FileName = File.Name "
,

/* 0036_select_recent_version */
"SELECT j1.JobId AS JobId, "
       "f1.FileId AS FileId, "
       "f1.FileIndex AS FileIndex, "
       "f1.PathId AS PathId, "
       "f1.Name AS Name, "
       "f1.LStat AS LStat, "
       "f1.MD5 AS MD5, "
       "f1.Fhinfo AS Fhinfo, "
       "f1.Fhnode AS Fhnode, "
       "j1.JobTDate "
"FROM "
  "(SELECT max(JobTDate) AS JobTDate, "
          "PathId, "
          "File.Name "
   "FROM File "
   "JOIN Job USING (JobId) "
   "WHERE File.JobId IN (%s) "
   "GROUP BY PathId, "
            "File.Name) AS t1, "
     "Job AS j1, "
     "File AS f1 "
"WHERE t1.JobTDate = j1.JobTDate "
  "AND j1.JobId IN (%s) "
  "AND t1.PathId = f1.PathId "
  "AND j1.JobId = f1.JobId "
  "AND t1.Name = f1.Name "
,

/* 0037_create_temp_accurate_jobids */
"CREATE TABLE btemp3%s AS "
"SELECT JobId, "
       "StartTime, "
       "EndTime, "
       "JobTDate, "
       "PurgedFiles "
"FROM Job "
"JOIN FileSet USING (FileSetId) "
"WHERE ClientId = %s "
  "AND Level = 'F' "
  "AND JobStatus IN ('T', "
                    "'W') "
  "AND Type = 'B' "
  "AND StartTime < '%s' "
  "AND FileSet.FileSetId = %s "
"ORDER BY Job.JobId DESC, "
         "Job.JobTDate DESC "
"LIMIT 1 "
,

/* 0038_create_temp_basefile */
"CREATE TEMPORARY TABLE basefile%lld ( Path TEXT, Name TEXT) "
,

/* 0039_create_temp_new_basefile */
"CREATE "
"TEMPORARY TABLE new_basefile%lld AS "
"SELECT Path.Path AS Path, "
       "Temp.Name AS Name, "
       "Temp.FileIndex AS FileIndex, "
       "Temp.JobId AS JobId, "
       "Temp.LStat AS LStat, "
       "Temp.FileId AS FileId, "
       "Temp.MD5 AS MD5, "
       "Temp.Fhinfo AS Fhinfo, "
       "Temp.Fhnode AS Fhnode "
"FROM (%s) AS Temp "
"JOIN Path ON (Path.PathId = Temp.PathId) "
"WHERE Temp.FileIndex > 0 "
,

/* 0040_uap_upgrade_copies_oldest_job */
"CREATE TEMPORARY TABLE cpy_tmp AS "
"SELECT MIN(JobId) AS JobId "
  "FROM Job "
 "WHERE Type = '%c' "
   "AND ( "
          "PriorJobId IN (%s) "
       "OR PriorJobId IN ( "
         "SELECT PriorJobId "
           "FROM Job "
          "WHERE JobId IN (%s) "
            "AND Type = 'B' "
          ") "
       ") "
 "GROUP BY PriorJobId "
,

/* 0041_uar_file */
"SELECT Job.JobId AS JobId, "
       "Path.Path||File.Name AS Name, "
       "StartTime, "
       "TYPE AS JobType, "
       "JobStatus, "
       "JobFiles, "
       "JobBytes "
"FROM Client, "
     "Job, "
     "File, "
     "Path "
"WHERE Client.Name='%s' "
  "AND Client.ClientId=Job.ClientId "
  "AND Job.JobId=File.JobId "
  "AND File.FileIndex > 0 "
  "AND Path.PathId=File.PathId "
  "AND File.Name='%s' "
"ORDER BY StartTime DESC "
"LIMIT 20 "
,

/* 0042_uar_create_temp */
"CREATE TEMPORARY TABLE "
       "temp ( "
	  "JobId INTEGER UNSIGNED NOT NULL, JobTDate BIGINT UNSIGNED, ClientId INTEGER UNSIGNED, Level CHAR, JobFiles INTEGER "
	  "UNSIGNED, JobBytes BIGINT UNSIGNED, StartTime TEXT, VolumeName TEXT, StartFile INTEGER UNSIGNED, VolSessionId INTEGER "
	  "UNSIGNED, VolSessionTime INTEGER UNSIGNED "
       ") "
,

/* 0043_uar_create_temp1 */
"CREATE TEMPORARY TABLE temp1 ( JobId INTEGER UNSIGNED NOT NULL, JobTDate BIGINT UNSIGNED) "
,

/* 0044_uar_jobid_fileindex_from_dir */
"SELECT Job.JobId, "
       "File.FileIndex "
"FROM Job, "
     "File, "
     "Path, "
     "Client "
"WHERE Job.JobId IN (%s) "
  "AND Job.JobId=File.JobId "
  "AND Path.Path='%s' "
  "AND Client.Name='%s' "
  "AND Job.ClientId=Client.ClientId "
  "AND Path.PathId=File.Pathid "
"GROUP BY File.FileIndex "
,

/* 0045_sql_media_order_most_recently_written */
"ORDER BY LastWritten IS NULL,LastWritten DESC,MediaId "
,

/* 0046_sql_get_max_connections */
"SELECT 0 "
,

/* 0047_bvfs_select */
"CREATE TABLE %s AS "
"SELECT File.JobId, "
       "File.FileIndex, "
       "File.FileId "
"FROM Job, "
     "File, "
  "(SELECT MAX(JobTDate) AS JobTDate, "
          "PathId, "
          "Name "
   "FROM btemp%s "
   "GROUP BY PathId, "
            "Name) AS T1 "
"WHERE T1.JobTDate = Job.JobTDate "
  "AND Job.JobId = File.JobId "
  "AND T1.PathId = File.PathId "
  "AND T1.Name = File.Name "
  "AND File.FileIndex > 0 "
  "AND Job.JobId IN "
    "(SELECT DISTINCT JobId "
     "FROM btemp%s) "
,

/* 0048_bvfs_list_files */
"SELECT 'F', "
       "T1.PathId, "
       "File.Name, "
       "File.JobId, "
       "File.LStat, "
       "File.FileId "
"FROM "
   "Job, "
   "File, "
   "( "
      "SELECT MAX(JobTDate) AS JobTDate, PathId, Name "
      "FROM ( "
         "SELECT JobTDate, PathId, File.Name "
         "FROM File "
         "JOIN Job USING (JobId) "
         "WHERE "
            "File.JobId IN (%s) AND "
            "PathId = %s "
        "UNION ALL "
        "SELECT JobTDate, PathId, File.Name "
        "FROM BaseFiles "
        "JOIN File USING (FileId) "
        "JOIN Job ON (BaseJobId = Job.JobId) "
        "WHERE "
           "BaseFiles.JobId IN (%s) AND "
           "PathId = %s "
      ") AS tmp "
      "GROUP BY PathId, Name "
      "LIMIT %lld "
      "OFFSET %lld "
   ") AS T1 "
"WHERE "
   "T1.JobTDate = Job.JobTDate AND "
   "Job.JobId = File.JobId AND "
   "T1.PathId = File.PathId AND "
   "T1.Name = File.Name AND "
   "File.Name != '' AND "
   "File.FileIndex > 0 %s "
   "AND ( "
      "Job.JobId IN ( "
         "SELECT DISTINCT BaseJobId FROM BaseFiles WHERE JobId IN (%s) "
      ") OR "
      "Job.JobId IN (%s) "
   ") "
,

/* 0049_batch_lock_path_query */
"BEGIN "
,

/* 0050_batch_lock_filename_query */
"BEGIN "
,

/* 0051_batch_unlock_tables_query */
"COMMIT "
,

/* 0052_batch_fill_path_query */
"INSERT INTO Path (Path) "
"SELECT DISTINCT Path "
  "FROM batch "
"EXCEPT "
"SELECT Path "
  "FROM Path "
,

/* 0053_batch_fill_filename_query */
"INSERT INTO Filename (Name) "
"SELECT DISTINCT Name "
  "FROM batch "
"EXCEPT "
"SELECT Name "
  "FROM Filename "
,

/* 0054_match_query */
 "AND Path2.Path LIKE '%s' "
,

/* 0055_match_query2 */
 "AND Filename.Name LIKE '%s' "
,

/* 0056_insert_counter_values */
"INSERT INTO Counters (Counter, MinValue, MaxValue, CurrentValue, WrapCounter) "
"VALUES ('%s','%d','%d','%d','%s') "
,

/* 0057_select_counter_values */
"SELECT MinValue, MaxValue, CurrentValue, WrapCounter "
  "FROM Counters "
 "WHERE Counter = '%s' "
,

/* 0058_update_counter_values */
"UPDATE Counters "
   "SET MinValue = %d, MaxValue = %d, CurrentValue = %d, WrapCounter = '%s' "
 "WHERE Counter  = '%s' "
,

/* 0059_get_quota_jobbytes */
"SELECT SUM(JobBytes) "
  "FROM Job "
 "WHERE ClientId  =  %s "
   "AND JobId     != %s "
   "AND SchedTime >  '%s' "
,

/* 0060_get_quota_jobbytes_nofailed */
"SELECT SUM(JobBytes) "
  "FROM Job "
 "WHERE ClientId  =  %s "
   "AND Job.JobId != %s "
   "AND SchedTime >  '%s' "
   "AND JobStatus NOT IN ('E','f','A') "
,

/* 0061_uar_sel_jobid_copies */
"SELECT DISTINCT JobId, StartTime "
  "FROM Job "
 "WHERE Type = 'C' "
   "AND (PriorJobId IN (%s)) "
 "ORDER BY StartTime ASC "
,

/* 0062_get_jobstatus_details */
"SELECT DISTINCT JobStatus, JobStatusLong, Severity, "
       "CASE "
       "WHEN JobStatus in ('T') THEN '0' "
       "WHEN JobStatus in ('W') THEN '1' "
       "WHEN JobStatus in ('e', 'f', 'A', 'E') THEN '2' "
       "END as ExitLevel, "
       "CASE "
       "WHEN JobStatus in ('T') THEN 'Ok' "
       "WHEN JobStatus in ('W') THEN 'Warning' "
       "WHEN JobStatus in ('e', 'f', 'A', 'E') THEN 'Error' "
       "END as ExitStatus "
  "FROM Status %s "
 "ORDER BY JobStatus "
,

/* 0063_bvfs_versions_6 */
"SELECT 'V', File.PathId, File.Name, File.JobId, File.LStat, File.FileId, File.Md5, Media.VolumeName, Media.InChanger "
"FROM File, Job, Client, JobMedia, Media "
"WHERE File.Name = '%s' "
  "AND File.PathId = %s "
  "AND File.JobId = Job.JobId "
  "AND Job.JobId = JobMedia.JobId "
  "AND File.FileIndex >= JobMedia.FirstIndex "
  "AND File.FileIndex <= JobMedia.LastIndex "
  "AND JobMedia.MediaId = Media.MediaId "
  "AND Job.ClientId = Client.ClientId "
  "AND Client.Name = '%s' "
  "%s "
"ORDER BY File.FileId "
"LIMIT %d "
"OFFSET %d "
,

/* 0064_bvfs_lsdirs_4 */
"%s "
"UNION "
"%s "
"ORDER BY Path ASC,JobId DESC "
"LIMIT %d "
"OFFSET %d "
,

/* 0065_bvfs_clear_cache_0.sqlite */
"BEGIN; "
   "UPDATE Job SET HasCache=0; "
   "DELETE FROM PathHierarchy; "
   "DELETE FROM PathVisibility; "
"COMMIT; "
,

/* 0066_bvfs_update_path_visibility_3.sqlite */
"INSERT INTO PathVisibility (PathId, JobId) "
"SELECT DISTINCT h.PPathId AS PathId, %s "
"FROM PathHierarchy AS h "
"WHERE "
   "h.PathId IN (SELECT PathId FROM PathVisibility WHERE JobId=%s) AND "
   "h.PPathId NOT IN (SELECT PathId FROM PathVisibility WHERE JobId=%s) "
,

/* 0067_list_volumes_count_0 */
"SELECT COUNT(DISTINCT Media.MediaId) as count FROM Media; "
,

/* 0068_list_volumes_by_name_count_1 */
"SELECT COUNT(DISTINCT Media.MediaId) as count "
"FROM Media "
"WHERE VolumeName='%s' "
,

/* 0069_list_volumes_by_poolid_count_1 */
"SELECT COUNT(DISTINCT Media.MediaId) as count "
"FROM Media "
"WHERE Media.PoolId=%s "
,

/* 0070_list_joblog_2 */
"SELECT Time, LogText FROM Log "
"WHERE Log.JobId=%s "
"ORDER BY Log.LogId "
"%s "
,

/* 0071_list_joblog_count_1 */
"SELECT COUNT(*) AS count "
"FROM Log "
"WHERE Log.JobId=%s "
,

/* 0072_get_orphaned_paths_0 */
"SELECT DISTINCT Path.PathId, File.PathId, Path.Path "
"FROM Path "
"LEFT JOIN File USING (PathId) "
"LEFT JOIN PathHierarchy ON (Path.Pathid = PathHierarchy.PPathId) "
"WHERE File.PathId IS NULL "
  "AND PathHierarchy.PPathId IS NULL "
"LIMIT 300000 "
,

/* 0073_get_bad_paths_0 */
"SELECT PathId, Path FROM Path "
"WHERE  Path != '' "
  "AND  Path NOT LIKE '%%/' "
,

/* 0074_bvfs_ls_special_dirs_3 */
"SELECT 'D', SpecialDir.PathId, SpecialDir.Path, JobId, LStat, FileId "
"FROM ( "
    "SELECT %s AS PathId, '.' AS Path "
    " "
    "UNION "
    " "
    "SELECT PPathId AS PathId, '..' AS Path "
    "FROM   PathHierarchy "
    "WHERE  PathId = %s "
") AS SpecialDir "
"LEFT JOIN ( "
    "SELECT PathId, JobId, LStat, FileId "
    "FROM File "
    "WHERE File.Name = '' "
      "AND File.JobId IN (%s) "
") AS DirAttribute "
"ON (SpecialDir.PathId = DirAttribute.PathId) "
,

/* 0075_bvfs_ls_sub_dirs_5 */
"SELECT 'D', PathId, Path, JobId, LStat, FileId "
"FROM ( "
   "SELECT "
      "Path1.PathId AS PathId, "
      "Path1.Path AS Path, "
      "lower(Path1.Path) AS lpath, "
      "listfile1.JobId AS JobId, "
      "listfile1.LStat AS LStat, "
      "listfile1.FileId AS FileId "
   "FROM ( "
      "SELECT listpath1.PathId AS PathId "
      "FROM ( "
         "SELECT DISTINCT PathHierarchy1.PathId AS PathId "
         "FROM PathHierarchy AS PathHierarchy1 "
         "INNER JOIN Path AS Path2 "
         "ON (PathHierarchy1.PathId = Path2.PathId) "
         "INNER JOIN PathVisibility AS PathVisibility1 "
         "ON (PathHierarchy1.PathId = PathVisibility1.PathId) "
         "WHERE PathHierarchy1.PPathId = %s "
         "AND PathVisibility1.JobId IN (%s) "
         ") AS listpath1 "
      "LEFT JOIN ( "
          "SELECT PVD1.PathId AS PathId "
          "FROM ( "
             "SELECT PV1.PathId AS PathId, MAX(JobId) AS MaxJobId "
             "FROM PathVisibility AS PV1 WHERE JobId IN (%s) GROUP BY PathId "
             ") AS PVD1 "
             "INNER JOIN File AS F2 "
             "ON (F2.PathId = PVD1.PathId AND F2.JobId = PVD1.MaxJobId AND F2.FileIndex = 0 AND F2.Name = '') "
      ") AS listpath2 "
      "ON (listpath1.PathId = listpath2.PathId) "
      "WHERE listpath2.PathId IS NULL "
      "%s "
   ") AS listpath3 "
   "INNER JOIN Path AS Path1 ON (listpath3.PathId = Path1.PathId) "
   "LEFT JOIN ( "
      "SELECT File1.PathId AS PathId, File1.JobId AS JobId, File1.LStat AS LStat, File1.FileId AS FileId "
      "FROM File AS File1 "
      "WHERE File1.Name = '' "
        "AND File1.JobId IN (%s) "
   ") AS listfile1 "
   "ON (listpath3.PathId = listfile1.PathId) "
") AS A "
,

/* 0076_list_volumes_select_0 */
"SELECT    MediaId,VolumeName,VolStatus,Enabled, "
          "VolBytes,VolFiles,VolRetention,Recycle,Slot,InChanger, "
          "MediaType,LastWritten,Name AS Storage "
"FROM      Media "
"LEFT JOIN Storage USING(StorageId) "
,

/* 0077_list_volumes_select_long_0 */
"SELECT    Media.MediaId, "
          "Media.VolumeName, "
          "Media.Slot, "
          "Media.PoolId, "
          "(SELECT Name FROM Pool WHERE Pool.PoolId=Media.PoolId) AS Pool, "
          "Media.MediaType, "
          "Media.FirstWritten, "
          "Media.LastWritten, "
          "Media.LabelDate, "
          "Media.VolJobs, "
          "Media.VolFiles, "
          "Media.VolBlocks, "
          "Media.VolMounts, "
          "Media.VolBytes, "
          "Media.VolErrors, "
          "Media.VolWrites, "
          "Media.VolCapacityBytes, "
          "Media.VolStatus, "
          "Media.Enabled, "
          "Media.Recycle, "
          "Media.VolRetention, "
          "Media.VolUseDuration, "
          "Media.MaxVolJobs, "
          "Media.MaxVolFiles, "
          "Media.MaxVolBytes, "
          "Media.InChanger, "
          "Media.EndFile, "
          "Media.EndBlock, "
          "Media.LabelType, "
          "Media.StorageId, "
          "Media.DeviceId, "
          "Media.LocationId, "
          "Media.RecycleCount, "
          "Media.InitialWrite, "
          "Media.ScratchPoolId, "
          "(SELECT Name FROM Pool WHERE Pool.PoolId=Media.ScratchPoolId) AS ScratchPool, "
          "Media.RecyclePoolId, "
          "(SELECT Name FROM Pool WHERE Pool.PoolId=Media.RecyclePoolId) AS RecyclePool, "
          "Media.Comment, "
          "Storage.Name AS Storage "
"FROM      Media "
"LEFT JOIN Storage USING(StorageId) "
,

/* 0078_bvfs_lock_pathhierarchy_0 */
"BEGIN "
,

/* 0079_bvfs_unlock_tables_0 */
"COMMIT "
,

NULL
};
