   /* general utility programs for the BenAri Concurrent PCODE sytem */

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

extern FILE *yyout;
extern void exit(int);
extern int fprintf(FILE*,const char*,...);
extern int vfprintf(FILE  *stream, const char *format, va_list ap);

char *savestr(char *s)
   /* copy a string s to new space & return a pointer to it */
{
char *t;
   t = (char *) malloc(1+strlen(s));
   if (t == (char *) 0) {
      fprintf(stderr,"savestr: malloc failed -- out of memory\n");
      exit(1);
   }
   strcpy(t,s);
   return(t);
}

void fatal(const char *fmt, ...)
   /* fmt is the format string                  */
   /* ... is the list of things to be printed   */
   /* output is written to stderr               */
   /* 'cfatal' in computil.c writes to stderr & yyout */
{
   va_list ap;

   fprintf(stderr, "Fatal error: ");
   va_start(ap,fmt);
   vfprintf(stderr,fmt,ap);
   va_end(ap);
   fprintf(stderr,"\n");
   exit(1);
}  /* fatal */

/*
 *
 *  $Log: genutil.c,v $
 * Revision 1.5  1997/11/04  06:41:43  bynum
 * add stdlib include for malloc on AIX
 *
 * Revision 1.4  1997/07/10  17:12:18  bynum
 * add fatal()
 *
 * Revision 1.3  1997/03/25  14:29:04  bynum
 * add externs & #include to silents complaints from gcc -Wall
 *
 * Revision 1.2  1995/09/07  16:03:14  bynum
 * fix fprintf call, do typecasting to satisfy fussy gcc on RS/6000
 *
 * Revision 1.1  1995/09/07  15:11:44  bynum
 * Initial revision
 *
 *
 */
