extern long time(long*);

/*  This is the minimal standard random number generator based on  */
/*  Schrage's method described on page 1195 of:                    */
/*     Random Number Generators: Good ones are hard to find        */
/*     Stephen K. Park & Keith W. Miller, CACM, v.31,10(Oct.88),   */
/*     pp. 1192 - 1201                                             */

static long int seed = 1;
static long int useed = 1;    /* user's random # generator */
const long A = 16807;
const long M = 2147483647;
const long Q = 127773;		/* M / A */
const long R = 2836;		/* M % A */

float strand()
  /* returns a pseudo-random float between 0 and 2^31 - 1 */
{
long int lo, hi, test;
float next;
   hi = seed / Q;
   lo = seed % Q;
   test = A * lo - R * hi;
   if (test > 0)
      seed = test; 
   else 
      seed = test + M; 
   next = (((float) seed)/M);
   return (next);
}	/* end of strand */


float ustrand()
  /* returns a pseudo-random float between 0 and 2^31 - 1 */
  /* for random number generator callable by user from interpreter */
{
long int lo, hi, test;
float next;
   hi = useed / Q;
   lo = useed % Q;
   test = A * lo - R * hi;
   if (test > 0)
      useed = test; 
   else 
      useed = test + M; 
   next = (((float) useed)/M);
   return (next);
}	/* end of ustrand */

void setseed(newseed)
long int newseed;
   /* sets a new seed, if 'newseed' is positive */
{
   if (newseed > 0) seed = newseed;
}

void randomize()
   /* sets random number generators' seeds from the clock */
{
long int temp;
   time(&temp);
      /* take lower 16 bits of current time & make them significant */
      /* (but non-zero) for the initial seed                        */
   seed = ((temp & 0xffff) << 16) + 31;
   useed = temp+seed;   /* start user somewhere else */
}

unsigned int   random(range)
unsigned int   range;
   /* returns a pseudo-random unsigned int between 0 and 'range' - 1 */
{
   return ((unsigned) ((float) range * strand()));
}

unsigned int   urandom(range)
unsigned int   range;
   /* returns a pseudo-random unsigned int between 0 and 'range' - 1 */
   /* for user-callable random number generator in interpreter       */
{
   return ((unsigned) ((float) range * ustrand()));
}
/*
 *
 *  $Log: random.c,v $
 * Revision 1.3  1997/03/25  14:59:04  bynum
 * delete time.h include
 *
 * Revision 1.2  1995/06/30  13:45:45  bynum
 * added 'ustrand' and 'urandom' functions with 'useed' to provide user
 * of interpreter with callable random number generator
 *
 * Revision 1.1  1995/06/22  06:50:07  bynum
 * Initial revision
 *
 *
 */
