#include "macros.h"
#include "types.h"

#define  STOP_VALUE  0

void main(argc, argv)
    int argc;
    char **argv;
{
    char msg[100];
    int word;
    float x, y, tol;
    FILE *fp;
    Bool found;

    if (argc != 3)
    {
        sprintf(msg, "correct syntax: %s <file> <tolerance>", argv[0]);
        ERROR_AND_EXIT(msg);
    }

    if (OPEN_FOR_BINARY_READING(fp, argv[1]))
    {
        sprintf(msg, "opening '%s' for reading", argv[1]);
        ERROR_AND_EXIT(msg);
    }

    tol = atof(argv[2]);

    printf("Value to look for (%d to stop): ", STOP_VALUE);
    scanf("%f", &x);

    while (x != STOP_VALUE)
    {
	rewind(fp);

	found = FALSE;
	for (word = 0; fread(&y, BYTES_PER_WORD, 1, fp) == 1; word++)
	{
	    if (ABS(x-y) < tol)
	    {
		printf("word %d = %f\n", word, y);
		found = TRUE;
		break;
	    }
	}

	if (!found)
	    printf("no value found within tolerance\n");

	printf("Value to look for (%d to stop): ", STOP_VALUE);
	scanf("%f", &x);
    }
}
