#include "macros.h"

void main(int argc, char **argv)
{
    char msg[100];
    float x;
    FILE *fp_in, *fp_out;
    int i, points_per_row = 1;

    if ((argc < 3) || (argc > 4))
    {
	sprintf(msg,
	    "correct syntax: %s <input file> <output file> [<points per row>]",
	    argv[0]);
	ERROR_AND_EXIT(msg);
    }

    if (argc == 4)
	points_per_row = MAX(1, atoi(argv[3]));

    if (OPEN_FOR_BINARY_READING(fp_in, argv[1]))
    {
	sprintf(msg, "opening '%s' for reading", argv[1]);
	ERROR_AND_EXIT(msg);
    }

    if (OPEN_FOR_WRITING(fp_out, argv[2]))
    {
	sprintf(msg, "opening '%s' for writing", argv[2]);
	ERROR_AND_EXIT(msg);
    }

    for (i = 1; fread(&x, BYTES_PER_WORD, 1, fp_in) == 1; i++)
    {
	fprintf(fp_out, "%f", x);

	if (i % points_per_row)
	    fprintf(fp_out, "\t");
	else
	    fprintf(fp_out, "\n");
    }
}
