#include "block.h"

#include "block_io.h"
#include "utility.h"

static int ndim;
static int *npoints;
static int *block_size;

static float *store;
static float *s;

static FILE *file_out;

static int ndim1;
static int total_nblocks;
static int size_of_block;
static int size_of_block1;
/*
static int read_size;
*/
static int write_size;
static int points;
static long int base_point;
static long int disk_point;

static int nblocks[MAX_NDIM];
static int block[MAX_NDIM];
static int point[MAX_NDIM];
static int npts[MAX_NDIM];
static int cum_npoints[MAX_NDIM];
static int cum_nblocks[MAX_NDIM];
static int cum_block_size[MAX_NDIM];

static Block_IO block_io_in;
static Block_IO block_io_out;

static Bool swapped;
static Bool integer;

static void init_arrays()
{
    int n;

    ndim1 = ndim - 1;

    BLOCKS(nblocks, npoints, block_size, ndim);

    CUMULATIVE(cum_npoints, npoints+1, n, ndim1);
    CUMULATIVE(cum_nblocks, nblocks+1, total_nblocks, ndim1);
    CUMULATIVE(cum_block_size, block_size+1, size_of_block1, ndim1);

    size_of_block = block_size[0] * size_of_block1;

/*
    read_size = nblocks[0] * size_of_block;
*/
}

static Status write_points(String error_msg)
{
    if (integer)
	int_words((int*) s, write_size);

    if (swapped)
        swap_bytes((char *) s, BYTES_PER_WORD*write_size);

/*
    if (FWRITE(s, BYTES_PER_WORD, write_size, file_out))
*/
    if (endian_fwrite((char *) s, write_size, file_out) == ERROR)
    {
	sprintf(error_msg, "writing points %d", points);
	return  ERROR;
    }

    points++;

    return  OK;
}

static Status unblock_blocks(String error_msg)
{
    int i, j, delta, n;

    for (i = 0; i < size_of_block1; i++)
    {
	ARRAY_OF_INDEX(point, i, cum_block_size, ndim1);

	for (j = 0; j < ndim1; j++)
	{
	    if (point[j] >= npts[j])
		break;
	}

	if (j < ndim1)
	    continue;

	s = store + i*block_size[0];

	INDEX_OF_ARRAY(n, point, cum_npoints, ndim1);
	delta = base_point + n*npoints[0] - disk_point;

	CHECK_STATUS(skip_file_blocks(&block_io_out, delta, error_msg));

	disk_point += delta;

	for (j = 0; j < nblocks[0]; j++)
	{
	    if (j == (nblocks[0]-1))
		write_size = 1 + (npoints[0]-1) % block_size[0];
	    else
		write_size = block_size[0];

	    CHECK_STATUS(write_points(error_msg));

	    s += size_of_block;
	    disk_point += write_size;
	}
    }

    return  OK;
}

Status block_process(Size_info *size_info, Store_info *store_info,
			File_info *file_info, String error_msg)
{
    int i, j, n, p, b;

    ndim = size_info->ndim;
    npoints = size_info->npoints;
    block_size = size_info->block_size;

    store = store_info->store;

    file_out = file_info->file_out;

    if (!(file_info->blocked))
	RETURN_ERROR_MSG("input file must be blocked");

    init_arrays();

    swapped = file_info->swapped_out;
    integer = file_info->integer_out;

    block_io_in.name = file_info->input_file;
    block_io_in.file = file_info->file_in;
    block_io_in.swapped = file_info->swapped_in;
    block_io_in.integer = file_info->integer_in;
    block_io_in.deflated = file_info->deflated;
    block_io_in.header = file_info->header;
    block_io_in.dir_size = file_info->dir_size;
    block_io_in.directory = store_info->directory;
    block_io_in.block_size = size_of_block;
    block_io_in.byte_size = BYTES_PER_WORD;

    block_io_out.name = file_info->output_file;
    block_io_out.file = file_info->file_out;
    block_io_out.block_size = 1;
    block_io_out.deflated = FALSE;

    CHECK_STATUS(init_block_read(&block_io_in, error_msg));
    CHECK_STATUS(init_block_write(&block_io_out, error_msg));

    points = 0;

    b = base_point = 0;

    p = MAX(total_nblocks/32, 1);
    for (i = 0; i < total_nblocks; i++)
    {
	if (!(i % p))
	{
	    printf("\t... working on block %d of %d\n", i+1, total_nblocks);
            FLUSH;
	}

	ARRAY_OF_INDEX(block, i, cum_nblocks, ndim1);

	n = 0;
	for (j = 0; j < ndim1; j++)
	    n += block[j] * block_size[j+1] * cum_npoints[j];

	base_point = n * npoints[0];

	for (j = 0; j < ndim1; j++)
	{
	    if (block[j] == (nblocks[j+1]-1))
		npts[j] = 1 + (npoints[j+1]-1) % block_size[j+1];
	    else
		npts[j] = block_size[j+1];
	}

	CHECK_STATUS(read_file_blocks(&block_io_in, b, nblocks[0], store, error_msg));

	CHECK_STATUS(unblock_blocks(error_msg));

	b += nblocks[0];
    }

    return  OK;
}
