#ifndef _incl_output
#define _incl_output

#include "macros.h"
#include "types.h"

#define  PLOT_DIM	2

static String output_gl_names[] =
{
#define  PS_OUTPUT	0
	"Postscript (PS)",

#define  EPS_OUTPUT	1
	"Encapsulated PS (EPS)",

#define  HPGL_OUTPUT	2
	"HPGL",

#ifdef USE_XPM
#define  XPM_OUTPUT	3
	"XPM",

#define  NGL_TYPES	4
	""
#else /* USE_XPM */
#define  NGL_TYPES	3
	""
#endif /* USE_XPM */
};

static String output_color_names[] =
{
#define  BLACK_WHITE	0
	"black and white",

#define  COLOR_GRAY	1
	"color or grayscale",

#define  NCOLOR_TYPES	2
	""
};

static String paper_dirn_names[] =
{
#define  PORTRAIT	0
	"portrait",

#define  LANDSCAPE	1
	"landscape",

#define  NPAPER_DIRNS	2
	""
};

#define  CMS_PER_IN	(2.54)
#define  PTS_PER_IN	(72.0)
#define  PTS_PER_CM	(72.0/CMS_PER_IN)

static String paper_size_names[] =
{
#define  A4_PAPER	0
    "A4 (21cm x 29.7cm)",

#define  A3_PAPER	1
    "A3 (29.7cm x 42cm)",

#define  A_PAPER	2
    "A  (8.5in x 11in)",

#define  B_PAPER	3
    "B  (11in x 17in)",

#define  OTHER_SIZE	4
    "other: ",

#define  NPAPER_SIZES	5
	""
};

typedef float Paper_size[PLOT_DIM];

static Paper_size paper_sizes[] =
{
    { 21.0 * PTS_PER_CM,	29.7 * PTS_PER_CM },	/* A4 */
    { 29.7 * PTS_PER_CM,	42.0 * PTS_PER_CM },	/* A3 */
    { 8.5 * PTS_PER_IN,		11.0 * PTS_PER_IN },	/* A */
    { 11.0 * PTS_PER_IN,	17.0 * PTS_PER_IN },	/* B */
    { 0,			0 }			/* Other */
};

static String size_mode_names[] =
{
#define  SIZE_PICTURE	0
	"picture",

#define  SIZE_MARGIN	1
	"margins",

#define  NSIZE_MODES	2
	""
};

static String size_units_names[] =
{
#define  INCH_UNITS	0
	"inches",

#define  CM_UNITS	1
	"cms",

#define  NSIZE_UNITS	2
	""
};

static String justification_names[] =
{
#define  JUSTIFICATION_LEFT		0
	"left",

#define  JUSTIFICATION_CENTER		1
	"center",

#define  JUSTIFICATION_RIGHT		2
	"right",

#define  NJUSTIFICATIONS		3
	""
};

static String edge_names[] =
{
#define  EDGE_TOP		0
	"top",

#define  EDGE_BOTTOM		1
	"bottom",

#define  NEDGES			2
	""
};

typedef struct
{
    String size_string;
    float *size;
}   Output_param;

typedef struct
{
    String text;
    String font_name;
    int font_size;
    int justification;
    int edge;
    Bool use;
}   Output_border;

typedef struct
{
    Output_border *title;
    Output_border *time_date;
    Output_border *file_name;
    float *plot_size;
    String other_size;
    int paper_size;
    int paper_dirn;
    int output_color;
    Bool outline_box;
}   Output_choices;

typedef struct
{
    int size_mode;
    int size_units;
    int output_gl;
    Output_choices *choices;
}   Output_setup;

extern Status get_output_param
	(Output_param *output_param, String error_msg);

extern float *get_paper_size
	(int size);

extern Status setup_output
	(Output_setup *output_setup, String error_msg);

extern void setup_border
	(Output_border *border, String text, String font_name,
		int font_size, int justification, int edge, Bool use);

extern float convert_to_printer_points
	(float p, int units);

#endif /* _incl_output */
