#ifndef _incl_script_command
#define _incl_script_command

#include "parse.h"

/* header files for the processing routines */

#include "arrange.h"
#include "avance.h"
#include "baseline.h"
#include "complex.h"
#include "convolve.h"
#include "fft.h"
#include "lp_extend.h" /* forward-backward LP */
#include "lp_first.h" /* old LP */
#include "lp_fit.h" /* new LP */
#include "lp_last.h" /* old LP */
#include "maxent.h"
#include "phase.h"
#include "weight.h"

static int parse_int[] = { PARSE_INT };
static int parse_float[] = { PARSE_FLOAT };
static int parse_string[] = { PARSE_STRING };
static int parse_int2[] = { PARSE_INT, PARSE_INT };
static int parse_float2[] = { PARSE_FLOAT, PARSE_FLOAT };
static int parse_float3[] = { PARSE_FLOAT, PARSE_FLOAT, PARSE_FLOAT };
static int parse_int3[] = { PARSE_INT, PARSE_INT, PARSE_INT };
static int parse_int4[] = { PARSE_INT, PARSE_INT, PARSE_INT, PARSE_INT };
static int parse_int_float[] = { PARSE_INT, PARSE_FLOAT };
static int parse_int2_float[] = { PARSE_INT, PARSE_INT, PARSE_FLOAT };
static int parse_int3_float[] =
			{ PARSE_INT, PARSE_INT, PARSE_INT, PARSE_FLOAT };
static int parse_int2_float2[] =
			{ PARSE_INT, PARSE_INT, PARSE_FLOAT, PARSE_FLOAT };
static int parse_comfile[] = { PARSE_FILE };
static int parse_string_int[] = { PARSE_STRING, PARSE_INT };
static int parse_string_int2[] = { PARSE_STRING, PARSE_INT, PARSE_INT };

/* table of processing commands */

static Parse_line command_parse_table[] =
{
/*    { "baseline",	2,	parse_int2,		init_base_poly },*/
	/* keep baseline for backwards compatibility for now */
	/* removed 30 March 1996 to avoid confusion with base_points */
    { "avance",		2,	parse_int2,		init_avance },
    { "avance2",	3,	parse_int2_float,	init_avance2 },
    { "avance_phase",	0,	(int *) NULL,		init_avance_phase },
    { "base_const",	1,	parse_int,		init_base_const },
    { "base_const2",	3,	parse_int3,		init_base_const2 },
    { "base_points",	1,	parse_string,		init_base_points },
    { "base_poly",	2,	parse_int2,		init_base_poly },
    { "base_poly2",	4,	parse_int4,		init_base_poly2 },
    { "base_subtract",	1,	parse_string,		init_base_subtract },
    { "base_subtract2",	3,	parse_string_int2,	init_base_subtract2 },
    { "base_trig",	2,	parse_int2,		init_base_trig },
    { "base_trig2",	4,	parse_int4,		init_base_trig2 },
    { "cft",		0,	(int *) NULL,		init_cft },
    { "cftn",		0,	(int *) NULL,		init_cftn },
    { "complex",	0,	(int *) NULL,		init_complex },
    { "complexify",	0,	(int *) NULL,		init_complexify },
    { "conjugate",	0,	(int *) NULL,		init_conjugate },
    { "conv_box",	1,	parse_int,		init_conv_box },
    { "conv_file",	2,	parse_string_int,	init_conv_file },
    { "conv_gaussian",	2,	parse_int_float,	init_conv_gaussian },
    { "conv_sine",	1,	parse_int,		init_conv_sine },
    { "conv_triangle",	1,	parse_int,		init_conv_triangle },
    { "convolve",	1,	parse_int,		init_convolve },
      /* keep convolve for backwards compatibility for now, same as conv_sine */
    { "conv_sine_ppm",	2,	parse_int_float,	init_conv_sine_ppm },
    { "cycle",		1,	parse_int,		init_cycle },
    { "decay",		1,	parse_float,		init_decay },
    { "decay_sw",	2,	parse_float2,		init_decay_sw },
    { "end_base_points",0,	(int *) NULL,		init_end_base_points },
    { "exchange",	0,	(int *) NULL,		init_exchange },
    { "fft",		0,	(int *) NULL,		init_fft },
    { "fftn",		0,	(int *) NULL,		init_fftn },
    { "gaussian",	2,	parse_float2,		init_gaussian },
    { "gaussian_sw",	3,	parse_float3,		init_gaussian_sw },
    { "hft",		0,	(int *) NULL,		init_hft },
    { "icft",		0,	(int *) NULL,		init_icft },
    { "icftn",		0,	(int *) NULL,		init_icftn },
    { "ifft",		0,	(int *) NULL,		init_ifft },
    { "ifftn",		0,	(int *) NULL,		init_ifftn },
    { "inv_cosine",	2,	parse_float2,		init_inv_cosine },
    { "irft",		0,	(int *) NULL,		init_irft },
    { "irftn",		0,	(int *) NULL,		init_irftn },
    { "isft",		0,	(int *) NULL,		init_isft },
    { "isftn",		0,	(int *) NULL,		init_isftn },
    { "lower",		1,	parse_int,		init_lower },
    { "lp_backward",	2,	parse_int2,		init_lp_backward },
    { "lp_extend",	3,	parse_int2_float,	init_lp_extend },
    { "lp_first",	4,	parse_int3_float,	init_lp_first },
    { "lp_first2",	4,	parse_int3_float,	init_lp_first2 },
    { "lp_forward",	2,	parse_int2,		init_lp_forward },
    { "lp_last",	4,	parse_int3_float,	init_lp_last },
    { "lp_last2",	4,	parse_int3_float,	init_lp_last2 },
    { "magnitude",	0,	(int *) NULL,		init_magnitude },
    { "magnitude2",	0,	(int *) NULL,		init_magnitude2 },
    { "mask_ppmm",	0,	(int *) NULL,		init_mask_ppmm },
    { "maxent",		1,	parse_string,		init_maxent },
    { "maxent_com",	1,	parse_comfile,		init_maxent_com },
    { "mirror_half",	0,	(int *) NULL,		init_mirror_half },
    { "mirror_zero",	0,	(int *) NULL,		init_mirror_zero },
    { "phase",		2,	parse_float2,		init_phase },
    { "phase2",		3,	parse_float3,		init_phase2 },
    { "range",		2,	parse_int2,		init_range },
    { "real",		0,	(int *) NULL,		init_real },
    { "reduce",		0,	(int *) NULL,		init_reduce },
    { "reverse",	0,	(int *) NULL,		init_reverse },
    { "rft",		0,	(int *) NULL,		init_rft },
    { "rftn",		0,	(int *) NULL,		init_rftn },
    { "riri2rrii",	0,	(int *) NULL,		init_riri2rrii },
    { "rrii2riri",	0,	(int *) NULL,		init_rrii2riri },
    { "scale",		3,	parse_int2_float,	init_scale },
    { "scale2",		4,	parse_int2_float2,	init_scale2 },
    { "set",		3,	parse_int2_float,	init_set },
    { "set2",		4,	parse_int2_float2,	init_set2 },
    { "sft",		0,	(int *) NULL,		init_sft },
    { "sftn",		0,	(int *) NULL,		init_sftn },
    { "shift",		1,	parse_int,		init_shift },
    { "sinebell",	1,	parse_float,		init_sinebell },
    { "sinebell2",	1,	parse_float,		init_sinebell2 },
    { "upper",		1,	parse_int,		init_upper },
    { "weight_file",	1,	parse_string,		init_weight_file },
    { "zerofill",	1,	parse_int,		init_zerofill },
    { (String) NULL,	0,	(int *) NULL,		no_parse_func }
};

#endif /* _incl_script_command */
