#ifndef _incl_slice
#define _incl_slice

#include "macros.h"
#include "types.h"
#include "consts.h"

#include "ref.h"

typedef struct
{
    int npoints;
    int npoints_orig;
    int first;
    int step;
    float *data;
    int ref_type;
    float lower[DISPLAY_DIM];
    float upper[DISPLAY_DIM];
    Ref_info *ref;
    int major_ticks[DISPLAY_DIM];
    int minor_ticks[DISPLAY_DIM];
    Bool ruler[DISPLAY_DIM];
    Bool axis[DISPLAY_DIM];
}   Slice_info;

extern void get_baseline_points
	(int *npoints, int **points);

extern float calculate_slice_point
	(int x, int width, Slice_info *info);

extern void do_slice
	(Draw_funcs *draw_funcs, Slice_info *slice_info);

extern void print_slice_point_stats
	(float *point, Print_funcs *print_funcs);

extern void print_slice_limits_stats
	(float *limits, Print_funcs *print_funcs);

#endif /* _incl_slice */
