#include "save_popup.h"

#include "save.hlp"

#include "callback.h"
#include "data.h"
#include "param.h"
#include "save_func.h"
#include "window.h"

#define  VISIBLE_ITEMS  7

static Widget save_popup = (Widget) NULL;
static Widget save_form;
static Widget save_list;

static Widget data_field;
static Widget param_field;

static Textfield_item textfield_items[] =
{
    { "data file: ", save_data, NO_CALLBACK, NO_DATA, &data_field },
    { "parameter file: ", save_param, NO_CALLBACK, NO_DATA, &param_field }
};

static int ntexts = ARRAY_SIZE(textfield_items);

#define  NREGION_TYPES  2

static Widget region_boxes[NREGION_TYPES];
static Radiobox_item region_items[] =
{
    { "whole", NO_CALLBACK, NO_DATA, region_boxes + WHOLE_REGION },
    { "display", NO_CALLBACK, NO_DATA, region_boxes + DISPLAY_REGION }
};

static int region_type = WHOLE_REGION;
static int nregion_types = ARRAY_SIZE(region_boxes);

static int nsave_sets = 0;

void update_save_params()
{
    if (save_popup)
    {
	get_textfields(textfield_items, ntexts);
	region_type = get_radio_state(region_boxes, nregion_types);

	sprintf(save_region, "%d", region_type);
    }
    else
    {
	if (*save_region)
	    region_type = atoi(save_region);
    }
}

void remove_save_set(int save_set)
{
    remove_save_set_func(save_set);

    if (save_set < nsave_sets)
    {
	if (save_list)
	    delete_from_list(save_list, save_set+1);

	nsave_sets--;
    }
}

void register_save_set(int save_set, String name)
{
    if (save_set >= nsave_sets)
    {
	if (save_list)
	    insert_in_list(save_list, name, 0);

	nsave_sets++;
    }

    register_save_set_func(save_set);
}

static void select_command(int save_set)
{
    save_select_func(save_set);
}

static void select_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int save_set;

    save_set = list_position(cbs);
    select_command(save_set);
}

Status save_select_command(String value, Generic_ptr data, String error_msg)
{
    int save_set;

    if (!data_name_exists(value, &save_set))
    {
	sprintf(error_msg, "data name '%s' unknown", value);
	return  ERROR;
    }

    select_command(save_set);

    return  OK;
}

static Status save_command(String error_msg)
{
    CHECK_STATUS(save_save_func(force_question, error_msg));

    return  OK;
}

static void save_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    update_save_params();

    if (save_command(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

Status save_save_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(save_command(error_msg));

    return  OK;
}

static String save_string_func(int n, Generic_ptr data)
{
    return  get_data_name(n);
}

static void create_save_popup(Widget parent)
{
    Widget label, buttons, radio, separator, texts;
    Scrolled_list_info save_list_info;
    Apply_dismiss_help_info adh_info;
    char apply_label[] = "save";

    update_save_params();

    save_popup = create_popup(parent, "Save Data Set");
    CHECK_WIDGET_WARNING(save_popup);

    save_form = create_form(save_popup);
    CHECK_WIDGET_DESTROY_WARNING(save_form, save_popup);

    label = create_label(save_form, "data sets:");
    CHECK_WIDGET_DESTROY_WARNING(label, save_popup);
    attachments(label, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    save_list_info.selection_policy = SINGLE_SELECT;
    save_list_info.nitems = nsave_sets;
    save_list_info.func = save_string_func;
    save_list_info.nvisible_items = VISIBLE_ITEMS;
    save_list_info.callback = select_callback;

    save_list = create_scrolled_list(save_form, &save_list_info);
    CHECK_WIDGET_DESTROY_WARNING(save_list, save_popup);
    attachments(WIDGET_PARENT(save_list), label, NO_ATTACH,
						FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(save_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, save_popup);
    attachments(separator, WIDGET_PARENT(save_list), NO_ATTACH,
						FORM_ATTACH, NO_ATTACH);

    texts = create_textfields(save_form, textfield_items, ntexts);
    CHECK_WIDGET_DESTROY_WARNING(texts, save_popup);
    attachments(texts, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(save_form, region_items, nregion_types,
						region_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, save_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(save_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, save_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    adh_info.apply_label = apply_label;
    adh_info.apply_callback = save_callback;
    adh_info.dismiss_form = save_form;
    adh_info.help_message = save_help;

    buttons = create_apply_dismiss_help(save_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons, save_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    manage_widget(save_form);
}

void save_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!save_popup)
	create_save_popup(parent);

    if (save_popup)
	popup(save_form);
}

Status save_popup_command(String value, Generic_ptr data, String error_msg)
{
    save_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
