#ifndef _incl_region_func
#define _incl_region_func

#include "macros.h"
#include "types.h"
#include "consts.h"

#define  EXPAND_REGION		0
#define  CONTRACT_REGION	1

#define  NO_STATS_FILE		0
#define  YES_STATS_FILE		1

typedef Bool (*Rectangle_func)(int *size, int *begin, int *end);
   
extern void set_region_func
	(int type, float *lower, float *upper);

extern Status find_region_func
	(int *p_ref_type, float *lower, float *upper, String error_msg);

extern Status region_apply_func
	(int *p_ref_type, float *lower, float *upper,
		int *fold_type, int *flip_type, String error_msg);

extern Status move_region_func
	(int *original, int *translation, String error_msg);

extern Status change_region_func
	(int *original, int *begin, int *end, int type, String error_msg);

extern Status find_box_region
	(int *p_ref_type, String x_range, String y_range,
	int *original, int *begin, int *end, String error_msg);

extern Status find_point_stats
	(Print_funcs *print_funcs, int *size, int *point, String error_msg);

extern Status region_select_func
	(int position, String error_msg);

extern Status region_insert_func
	(YesNo_func func, String error_msg);

extern Status region_go_to_func
	(int *p_ref_type, String error_msg);

extern Status region_delete_func
	(int *position, String error_msg);

extern Status region_stats_func
	(Print_funcs *print_funcs, Rectangle_func rectangle_func,
							String error_msg);

extern Status region_whole_func
	(String error_msg);

extern void region_stats_close_func
	();

extern Status region_stats_open_func
	(String file, String error_msg);

#endif /* _incl_region_func */
