#include "region.h"

#include "ref.h"
#include "utility.h"

#define  SMALLEST_RANGE  (1.0e-4)

Status find_region(Region_info *info, String error_msg)
{
    float d;
    float x_range[DISPLAY_DIM], y_range[DISPLAY_DIM];

    if (get_floats(DISPLAY_DIM, x_range, info->x_region) == ERROR)
    {
	sprintf(error_msg, "need lower and upper values for x region");
	return  ERROR;
    }

    d = x_range[1] - x_range[0];

    if (d < SMALLEST_RANGE)
    {
	sprintf(error_msg, "x region range = %7.2e, must be > %7.2e",
							d, SMALLEST_RANGE);
	return  ERROR;
    }

    if (get_floats(DISPLAY_DIM, y_range, info->y_region) == ERROR)
    {
	sprintf(error_msg, "need lower and upper values for y region");
	return  ERROR;
    }

    d = y_range[1] - y_range[0];

    if (d < SMALLEST_RANGE)
    {
	sprintf(error_msg, "y region range = %7.2e, must be > %7.2e",
							d, SMALLEST_RANGE);
	return  ERROR;
    }

    info->lower[0] = x_range[0];
    info->lower[1] = y_range[0];
    info->upper[0] = x_range[1];
    info->upper[1] = y_range[1];

    return  OK;
}

void region_limits(int ref_type, int ndata_sets, Data_info *info,
				float *lower_limit, float *upper_limit)
{
    int i, j, ndim = DISPLAY_DIM;
    float lower[DISPLAY_DIM], upper[DISPLAY_DIM];

    for (j = 0; j < ndim; j++)
    {
	lower_limit[j] = LARGE_FLOAT;
	upper_limit[j] = - LARGE_FLOAT;
    }

    for (i = 0; i < ndata_sets; i++)
    {
	for (j = 0; j < ndim; j++)
	{
	    lower[j] = 0.5;
	    upper[j] = info[i].npoints[j] + 0.5;
	}

	convert_range_from_points(ref_type, ndim, info[i].npoints,
						info[i].ref, lower, upper);

	for (j = 0; j < ndim; j++)
	{
	    lower_limit[j] = MIN(lower[j], lower_limit[j]);
	    upper_limit[j] = MAX(upper[j], upper_limit[j]);
	}
    }
}
