#include "prop_popup.h"

#include "property.hlp"

#include "callback.h"
#include "color.h"
#include "data.h"
#include "display_popup.h"
#include "object.h"
#include "param.h"
#include "prop_func.h"
#include "window.h"

#define  DEFAULT_SCALE  1.0

#define  VISIBLE_ITEMS  7

static Widget property_popup = (Widget) NULL;
static Widget property_form;
static Widget property_list;

static Widget color_field;
static Widget scale_field;

static Textfield_item textfield_items[] =
{
    { "color: ", object_color, NO_CALLBACK, NO_DATA, &color_field },
    { "scale: ", object_scale, NO_CALLBACK, NO_DATA, &scale_field }
};

static int ntexts = ARRAY_SIZE(textfield_items);

static Widget object_boxes[NDATA_OBJECTS];
static Checkbox_item object_items[NDATA_OBJECTS];

static int nobject_types = ARRAY_SIZE(object_boxes);

#define  NVISIBILITY_TYPES  2

static Widget visibility_boxes[NVISIBILITY_TYPES];
static Radiobox_item visibility_items[] =
{
    { "visible", NO_CALLBACK, NO_DATA, visibility_boxes + VISIBILITY_ON },
    { "invisible", NO_CALLBACK, NO_DATA, visibility_boxes + VISIBILITY_OFF }
};

static int visibility_type = VISIBILITY_ON;
static int nvisibility_types = ARRAY_SIZE(visibility_boxes);

static int nproperty_sets = 0;

static char f_format[] = "%3.2f";

void update_property_params()
{
    if (property_popup)
    {
	get_textfields(textfield_items, ntexts);
	visibility_type = get_radio_state(visibility_boxes, nvisibility_types);

	sprintf(object_visible, "%d", visibility_type);
    }
    else
    {
	if (!(*object_scale))
	    sprintf(object_scale, f_format, DEFAULT_SCALE);

	if (*object_visible)
	    visibility_type = atoi(object_visible);
    }
}

void remove_property_set(int property_set)
{
    remove_property_set_func(property_set);

    if (property_set < nproperty_sets)
    {
	if (property_list)
	    delete_from_list(property_list, property_set+1);

	nproperty_sets--;
    }
}

void register_property_set(int property_set, String name)
{
    if (property_set >= nproperty_sets)
    {
	if (property_list)
	    insert_in_list(property_list, name, 0);

	nproperty_sets++;
    }

    register_property_set_func(property_set);
}

static void object_command(int object)
{
    prop_object_func(object);
}

static void object_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int object = (int) data;

    object_command(object);
}

Status prop_object_command(String value, Generic_ptr data, String error_msg)
{
    int object;

    if (!object_name_exists(NDATA_OBJECTS, value, &object))
    {
	sprintf(error_msg, "object name '%s' unknown", value);
	return  ERROR;
    }

    object_command(object);

    return  OK;
}

static void select_command(int property_set)
{
    prop_select_func(property_set);
}

static void select_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int property_set;

    property_set = list_position(cbs);
    select_command(property_set);
}

Status prop_select_command(String value, Generic_ptr data, String error_msg)
{
    int property_set;

    if (!data_name_exists(value, &property_set))
    {
	sprintf(error_msg, "data name '%s' unknown", value);
	return  ERROR;
    }

    select_command(property_set);

    return  OK;
}

static void apply_command()
{
    do_display_drawing();
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    apply_command();
}

Status prop_apply_command(String value, Generic_ptr data, String error_msg)
{
    apply_command();

    return  OK;
}

static void get_command()
{
    prop_get_func();

    visibility_type = atoi(object_visible);

    if (property_popup)
    {
	set_textfields(textfield_items, ntexts);
	set_radio_state(visibility_boxes, nvisibility_types, visibility_type);
    }
}

static void get_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    get_command();
}

Status prop_get_command(String value, Generic_ptr data, String error_msg)
{
    get_command();

    return  OK;
}

static void set_command()
{
    update_property_params();

    prop_set_func();

    if (property_popup)
    {
	set_textfields(textfield_items, ntexts);
			/* only needed because scale might be reset */
    }
}

static void set_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    set_command();
}

Status prop_set_command(String value, Generic_ptr data, String error_msg)
{
    set_command();

    return  OK;
}

static String property_string_func(int n, Generic_ptr data)
{
    return  get_data_name(n);
}

static void initial_selection()
{
    int i;

    for (i = 0; i < nproperty_sets; i++)
    {
        if (data_property_selected(i))
            select_from_list(property_list, i+1, FALSE);
    }

}

static void color_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    String name = (String) data;
    strcpy(object_color, name);

    set_textfields(textfield_items, 1);
}

static void create_property_popup(Widget parent)
{
    int i, objects_set;
    Widget label, buttons, radio, separator, texts, check, dropdown;
    Scrolled_list_info property_list_info;
    static Button_item button_items[] =
    {
	{ "apply",	apply_callback,		NO_DATA },
	{ "get",	get_callback,		NO_DATA },
	{ "set",	set_callback,		NO_DATA },
#define  DISMISS_BUTTON  3
	{ "dismiss",	dismiss_callback,	NO_DATA },
	{ "help",	help_callback,		(Callback_ptr) property_help }
    };
    static int nbuttons = ARRAY_SIZE(button_items);
    static Dropdown_list_info dropdown_list_info;

    update_property_params();

    property_popup = create_popup(parent, "Data Set Properties");
    CHECK_WIDGET_WARNING(property_popup);

    property_form = create_form(property_popup);
    CHECK_WIDGET_DESTROY_WARNING(property_form, property_popup);

    label = create_label(property_form, "data sets:");
    CHECK_WIDGET_DESTROY_WARNING(label, property_popup);
    attachments(label, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    property_list_info.selection_policy = MULTIPLE_SELECT;
    property_list_info.nitems = nproperty_sets;
    property_list_info.func = property_string_func;
    property_list_info.nvisible_items = VISIBLE_ITEMS;
    property_list_info.callback = select_callback;

    property_list = create_scrolled_list(property_form, &property_list_info);
    CHECK_WIDGET_DESTROY_WARNING(property_list, property_popup);
    attachments(WIDGET_PARENT(property_list), label, NO_ATTACH,
						FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(property_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, property_popup);
    attachments(separator, WIDGET_PARENT(property_list), NO_ATTACH,
						FORM_ATTACH, NO_ATTACH);

    for (i = 0; i < nobject_types; i++)
    {
	object_items[i].label = object_labels[i];
	object_items[i].data = (Generic_ptr) i;
	object_items[i].box = object_boxes + i;
        object_items[i].callback = object_callback;
    }

    objects_set = prop_objects_set();
    check = create_checkbox(property_form, object_items, nobject_types,
						objects_set, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(check, property_popup);
    attachments(check, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(property_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, property_popup);
    attachments(separator, check, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    dropdown_list_info.label = (char *) NULL;
    dropdown_list_info.nitems = get_ncolors();
    dropdown_list_info.items = get_color_names();
    dropdown_list_info.callback_names = TRUE;
    dropdown_list_info.callback = color_callback;

    dropdown = create_dropdown_list(property_form, &dropdown_list_info);
    CHECK_WIDGET_DESTROY_WARNING(dropdown, property_popup);
    attachments(dropdown, separator, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    texts = create_textfields(property_form, textfield_items, ntexts);
    CHECK_WIDGET_DESTROY_WARNING(texts, property_popup);
    attachments(texts, dropdown, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(property_form, visibility_items, nvisibility_types,
						visibility_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, property_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(property_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, property_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    button_items[DISMISS_BUTTON].data = (Callback_ptr) property_form;
    buttons = create_horizontal_buttons(property_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, property_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, NO_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(property_form);

    initial_selection();
}

void property_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!property_popup)
	create_property_popup(parent);

    if (property_popup)
	popup(property_form);
}

Status prop_popup_command(String value, Generic_ptr data, String error_msg)
{
    property_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
