#ifndef _incl_position
#define _incl_position

#include "macros.h"
#include "types.h"
#include "consts.h"

typedef struct
{
    char *name;
    int ref_type;
    float lower[DISPLAY_DIM];
    float upper[DISPLAY_DIM];
}   Position_info;

extern void save_positions
	();

extern void new_position_info
	(int position, int ref_type, float *lower, float *upper);

extern Status initialize_position
	(char *name, int ref_type, float *lower, float *upper,
						String error_msg);

extern void read_positions
	();

extern int get_number_positions
	();

extern void get_position_info
	(int position, Position_info **info);

extern Bool position_name_exists
	(String name, int *position);

extern char *get_position_name
	(int position);

extern void delete_position
	(int position);

#endif /* _incl_position */
