#include "position.h"

#define  POSITION_FILE  ".position"

#define  POSITION_ALLOC  8

static int npositions = 0;
static int npositions_alloc = 0;

static Position_info *position_info;

static char position_file[] = POSITION_FILE;

void save_positions()
{
    int i;
    FILE *fp;

    if ((npositions > 0) && !OPEN_FOR_WRITING(fp, position_file))
    {
	for (i = 0; i < npositions; i++)
	{
	    fprintf(fp, "%s\n", position_info[i].name);
	    fprintf(fp, "%d %5.2f %5.2f %5.2f %5.2f\n",
		position_info[i].ref_type,
		position_info[i].lower[0], position_info[i].upper[0],
		position_info[i].lower[1], position_info[i].upper[1]);
	}

	fclose (fp);
    }
}

static Status alloc_position_memory(char *name)
{
    int n;

    if (npositions >= npositions_alloc)
    {
	n = npositions_alloc + POSITION_ALLOC;

	if (npositions_alloc == 0)
	{
	    MALLOC(position_info, Position_info, n);
	}
	else
	{
	    REALLOC(position_info, Position_info, n);
	}

	npositions_alloc = n;
    }

    n = strlen(name) + 1;

    MALLOC(position_info[npositions].name, char, n);

    return  OK;
}

void new_position_info(int position, int ref_type, float *lower, float *upper)
{
    position_info[position].ref_type = ref_type;
    COPY_VECTOR(position_info[position].lower, lower, DISPLAY_DIM);
    COPY_VECTOR(position_info[position].upper, upper, DISPLAY_DIM);
}

Status initialize_position(char *name, int ref_type,
				float *lower, float *upper, String error_msg)
{
    STRIP_LEADING_SPACE(name);
    STRIP_TRAILING_SPACE(name);

    sprintf(error_msg, "allocating memory for position");
    CHECK_STATUS(alloc_position_memory(name));

    strcpy(position_info[npositions].name, name);
    new_position_info(npositions, ref_type, lower, upper);

    npositions++;

    return  OK;
}

void read_positions()
{
    int ref_type;
    float lower[DISPLAY_DIM], upper[DISPLAY_DIM];
    Line name, line, error_msg;
    FILE *fp;

    if (!OPEN_FOR_READING(fp, position_file))
    {
	while (fgets(name, LINE_SIZE, fp))
	{
	    if (fgets(line, LINE_SIZE, fp) &&
		(sscanf(line, "%d %f %f %f %f",
			&ref_type, lower, upper, lower+1, upper+1) == 5))
		if (initialize_position(name, ref_type, lower, upper,
							error_msg) == ERROR)
		    break;
	}

	fclose (fp);
    }
}

int get_number_positions()
{
    return  npositions;
}

void get_position_info(int position, Position_info **info)
{
    if (position < npositions)
	*info = position_info + position;
    else
	*info = (Position_info *) NULL;
}

Bool position_name_exists(String name, int *position)
{
    int i;

    STRIP_LEADING_SPACE(name);
    STRIP_TRAILING_SPACE(name);

    for (i = 0; i < npositions; i++)
    {
	if (!strcmp(name, position_info[i].name))
	{
	    *position = i;
	    return  TRUE;
	}
    }

    return  FALSE;
}

char *get_position_name(int position)
{
    static char string[] = "";

    if (position < npositions)
	return  position_info[position].name;
    else
	return  string;
}

void delete_position(int position)
{
    int i;

    if (position < npositions)
    {
	FREE(position_info[position].name, char);

	for (i = position; i < npositions-1; i++)
	    position_info[i] = position_info[i+1];  /* struct copy */

	npositions--;
    }
}
