#include "phase.h"

#include "ft.h"
#include "utility.h"

static int npts;
static int npts2;
static int npts_alloc = 0;
static float *data1 = NULL;
static float *data2 = NULL;

void free_phase_memory()
{
    FREE(data1, float);
    FREE(data2, float);

    npts_alloc = 0;
}

static Status alloc_phase_memory()
{
    if (npts2 > npts_alloc)
    {
	free_phase_memory();

	MALLOC(data1, float, 2*npts2);
	MALLOC(data2, float, npts2);

	npts_alloc = npts2;
    }

    return  OK;
}

Status initialize_phase(int npoints, float **data, String error_msg)
{
    float *d = *data;

    npts = npoints;
    npts2 = ceil_power_of_2(npts);
	/* hft must have power of 2 */

    if (alloc_phase_memory() == ERROR)
	RETURN_ERROR_MSG("allocating memory for phasing");

    COPY_VECTOR(data1, d, npts);
    ZERO_VECTOR(data1+npts, npts2-npts);

    hft(data1, npts2);  /* data is real, so complexify only way know how */

    *data = data2;

    return  OK;
}

void do_phasing(Phase_info *info)
{
    int i, j;
    float c, s, piv, ph0, ph1;
    double angle;

    piv = info->pivot - 1;
    ph0 = RADIAN_SCALE * info->phase0;
    ph1 = RADIAN_SCALE * info->phase1 / ((float) npts2);

    angle = ph0 - piv*ph1;
    for (i = 0, j = 0; i < npts2; i++, j += 2)
    {
	c = cos(angle);
	s = sin(angle);
	data2[i] = c*data1[j] + s*data1[j+1];
	angle += ph1;
    }
}
