#include "peaks_func.h"

#include "data.h"
#include "param.h"
#include "peak.h"
#include "region.h"

#define PEAKS_SEPARATOR  "\t\n"

static int npeaks = 0;
static int npeaks_selected = 0;
static int *peaks_selected = (int *) NULL;

static Status get_string(String var, String line, String error_msg)
/*
static Status get_string(String *var, String line, String error_msg)
*/
{
    String ptr = strtok(line, PEAKS_SEPARATOR);

    if (!ptr)
	RETURN_ERROR_MSG("parsing line");

/*
    sprintf(error_msg, "allocating peak attribute memory");
    STRING_MALLOC_COPY(*var, ptr);
*/
    strcpy(var, ptr);

    return  OK;
}

static Status get_int(int *var, String line, String error_msg)
{
    String ptr = strtok(line, PEAKS_SEPARATOR);

    if (!ptr)
	RETURN_ERROR_MSG("parsing line");

    *var = atoi(ptr);

    return  OK;
}

static Status get_float(float *var, String line, String error_msg)
{
    String ptr = strtok(line, PEAKS_SEPARATOR);

    if (!ptr)
	RETURN_ERROR_MSG("parsing line");

    *var = atof(ptr);

    return  OK;
}

static Status new_peak_parse(String line, Add_peak_func add_func,
							String error_msg)
{
    int x, y;
    float x_ppm, y_ppm, extremum;
/*
    String set, name, ptr, rest = NULL;
*/
    Line set, name;

/*
    CHECK_STATUS(get_string(&set, line, error_msg));
    CHECK_STATUS(get_string(&name, NULL, error_msg));
*/
    CHECK_STATUS(get_string(set, line, error_msg));
    CHECK_STATUS(get_string(name, NULL, error_msg));
    CHECK_STATUS(get_int(&x, NULL, error_msg));
    CHECK_STATUS(get_float(&x_ppm, NULL, error_msg));
    CHECK_STATUS(get_int(&y, NULL, error_msg));
    CHECK_STATUS(get_float(&y_ppm, NULL, error_msg));
    CHECK_STATUS(get_float(&extremum, NULL, error_msg));

    CHECK_STATUS(add_peak(set, name, x, x_ppm, y, y_ppm, extremum, add_func, error_msg));
    npeaks++;

    return  OK;
}

Status peaks_load_func(Add_peak_func add_func, String error_msg)
{
    int n;
    FILE *fp;
    String msg;
    Line line;

    CHECK_OPEN_FOR_READING(fp, peaks_file);

    fgets(line, LINE_SIZE, fp); /* header */

    for (n = 0; fgets(line, LINE_SIZE, fp); n++)
	;

    rewind(fp);

    fgets(line, LINE_SIZE, fp); /* header */

    for (n = 0; fgets(line, LINE_SIZE, fp); n++)
    {
	sprintf(error_msg, "peak #%d: ", npeaks+1);
	msg = error_msg + strlen(error_msg);

	if (new_peak_parse(line, add_func, msg) == ERROR)
	{
	    FCLOSE(fp);

	    return  ERROR;
	}
    }

    FCLOSE(fp);

    return  OK;
}

Status peaks_save_func(String error_msg)
{
    int i, n;
    FILE *fp;
    Peak *p, **peaks = get_peaks(&n);

    CHECK_OPEN_FOR_WRITING(fp, peaks_file);

    fprintf(fp, "set\tname\tx\tx_ppm\ty\ty_ppm\textremum");
    fprintf(fp, "\tfit_extr\tparam\tmethod\tA\tB\tC\terr2\n");

    for (i = 0; i < npeaks; i++)
    {
	p = peaks[i];

	fprintf(fp, "%s\t%s\t%d\t%5.4f\t%d\t%5.4f\t%4.3e",
		p->peak_set->set, p->name, p->x, p->x_ppm,
		p->y, p->y_ppm, p->extremum);

	if (p->have_fit)
	{
	    fprintf(fp, "\t%4.3e\t%3.2f\t%d\t%4.3e\t%4.3e\t%4.3e\t%3.2e",
		p->fit_extremum, p->param, p->peak_set->method,
		p->peak_set->param1, p->peak_set->param2, p->peak_set->param3,
		p->peak_set->chisq);
	}
	else
	{
	    fprintf(fp, "\t\t\t\t\t\t\t");
	}

	fprintf(fp, "\n");
    }

    FCLOSE(fp);

    return  OK;
}

void peak_select_func(int npeaks_sel, int *peaks_sel)
{
    FREE(peaks_selected, int);
    npeaks_selected = npeaks_sel;
    peaks_selected = peaks_sel;

/*
    if ((*peak < 0) || (*peak >= npeaks) || (current_peak == *peak))
	*peak = current_peak = -1;
    else
	current_peak = *peak;
*/
}

static Status peak_extremum(int data_set, String set, String name,
			int x, float x_ppm, int y, float y_ppm,
			float extremum, Generic_ptr data, String error_msg)
{
/*
    String peak_set, peak_name;
*/
    Add_peak_func add_func = (Add_peak_func) data;

/*
    sprintf(error_msg, "allocating peak attribute memory");
    STRING_MALLOC_COPY(peak_set, set);
    STRING_MALLOC_COPY(peak_name, name);

    CHECK_STATUS(add_peak(peak_set, peak_name, x, x_ppm, y, y_ppm, extremum, rest, add_func, error_msg));
*/
    CHECK_STATUS(add_peak(set, name, x, x_ppm, y, y_ppm, extremum, add_func, error_msg));
    npeaks++;

    return  OK;
}

Status add_peak_func(String set, int ref_type, String x_range,
		String y_range, Add_peak_func add_func, String error_msg)
{
    Region_info info;
    float lower[DISPLAY_DIM], upper[DISPLAY_DIM];

    info.lower = lower;
    info.upper = upper;
    info.x_region = x_range;
    info.y_region = y_range;

    CHECK_STATUS(find_region(&info, error_msg));
    check_orientation(ref_type, DISPLAY_DIM, lower, upper);
    CHECK_STATUS(find_data_extremum(set, ref_type, lower, upper, peak_extremum, (Generic_ptr) add_func, error_msg));

    return  OK;
}

Status peak_delete_func(int *npeaks_deleted, int **peaks_deleted,
							String error_msg)
{
/*
    if (current_peak == -1)
        RETURN_ERROR_MSG("no peak selected");

    delete_peak(current_peak);

    *peak = current_peak;

    current_peak = -1;
    npeaks--;
*/
    int i;

    for (i = npeaks_selected-1; i >= 0; i--)
    {
	delete_peak(peaks_selected[i]);
	npeaks--;
    }

    *npeaks_deleted = npeaks_selected;
    *peaks_deleted = peaks_selected;
    npeaks_selected = 0;
    peaks_selected = (int *) NULL;
    /* calling code responsible for actually freeing memory */

    return  OK;
}

static Status stretch_peak(int data_set, String set, String name,
			int x, float x_ppm, int y, float y_ppm,
			float extremum, Generic_ptr data, String error_msg)
{
    float w[DISPLAY_DIM];

    w[0] = x_ppm;
    w[1] = y_ppm;

    set_data_scale_offset(data_set, w, extremum);

    return  OK;
}

Status stretch_peak_func(int ref_type, String x_range, String y_range,
							String error_msg)
{
    Region_info info;
    float lower[DISPLAY_DIM], upper[DISPLAY_DIM];

    info.lower = lower;
    info.upper = upper;
    info.x_region = x_range;
    info.y_region = y_range;

    CHECK_STATUS(find_region(&info, error_msg));
    check_orientation(ref_type, DISPLAY_DIM, lower, upper);
    CHECK_STATUS(find_data_extremum(NULL, ref_type, lower, upper, stretch_peak, NULL, error_msg));

    return  OK;
}
