#include "peak_popup.h"

#include "peak.hlp"

#include "callback.h"
#include "ref.h"
#include "ref_popup.h"
#include "utility.h"
#include "window.h"

static Widget peak_popup = (Widget) NULL;
static Widget peak_form;

static Widget set_field;
static Widget xrange_field;
static Widget yrange_field;

static Line peak_set;
static Line peak_x_range;
static Line peak_y_range;

static Bool have_answer;
static Bool peak_answer;

static Widget reference_boxes[NREF_TYPES];
static Radiobox_item reference_items[NREF_TYPES];

static int peak_ref_type = REF_POINTS;
static int nref_types = ARRAY_SIZE(reference_boxes);

static Textfield_item peak_items[] =
{
    { "peak set: ", peak_set, NO_CALLBACK, NO_DATA, &set_field },
    { "x region: ", peak_x_range, NO_CALLBACK, NO_DATA, &xrange_field },
    { "y region: ", peak_y_range, NO_CALLBACK, NO_DATA, &yrange_field }
};

static int nfields = ARRAY_SIZE(peak_items);

static void update_peak_params()
{
    if (peak_popup)
    {
	peak_ref_type = get_radio_state(reference_boxes, nref_types);
	get_textfields(peak_items, nfields);
    }
}

static void add_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    peak_answer = TRUE;
    have_answer = TRUE;
}

static void cancel_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    peak_answer = FALSE;
    have_answer = TRUE;
}

static void create_peak_popup(Widget parent)
{
    Widget buttons, texts, radio;
    static Button_item button_items[] =
    {
    	{ "add",	add_callback,		NO_DATA },
    	{ "cancel",	cancel_callback,	NO_DATA },
    	{ "help",	help_callback,		(Callback_ptr) peak_help }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    peak_popup = create_popup(parent, "Add Peak");
    CHECK_WIDGET_WARNING(peak_popup);

    peak_form = create_form(peak_popup);
    CHECK_WIDGET_DESTROY_WARNING(peak_form, peak_popup);

    texts = create_textfields(peak_form, peak_items, nfields);
    CHECK_WIDGET_DESTROY_WARNING(texts, peak_popup);
    attachments(texts, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    set_reference_items((Box_item *) reference_items, reference_boxes);
    radio = create_radiobox(peak_form, reference_items, nref_types,
						peak_ref_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, peak_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    buttons = create_horizontal_buttons(peak_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, peak_popup);
    attachments(buttons, radio, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    change_delete_protocol(peak_popup, cancel_callback);

    manage_widget(peak_form);
}

Bool add_peak_dialog(String set, int *p_ref_type,
					String x_range, String y_range)
{
    strcpy(peak_set, set);
    strcpy(peak_x_range, x_range);
    strcpy(peak_y_range, y_range);
    peak_ref_type = *p_ref_type;

    if (!peak_popup)
        create_peak_popup(get_topshell());

    if (peak_popup)
    {
	set_textfields(peak_items, nfields);
	set_radio_state(reference_boxes, nref_types, peak_ref_type);

	have_answer = FALSE;

        popup(peak_form);

	/* really want this dialog to be modal but not sure how to do that */
	while (!have_answer)
	    check_for_event();

        popdown(peak_form);
	update_peak_params();

	if (peak_answer)
	{
	    STRIP_LEADING_SPACE(set);
	    STRIP_TRAILING_SPACE(set);

	    strcpy(set, peak_set);
	    strcpy(x_range, peak_x_range);
	    strcpy(y_range, peak_y_range);
	}

	*p_ref_type = peak_ref_type;

	return peak_answer;
    }

    return FALSE;
}

void add_peak_popup()
{
    if (peak_popup)
	popup(peak_form);
}
