#include "object_popup.h"

#include "object.hlp"

#include "callback.h"
#include "color.h"
#include "data.h"
#include "display_popup.h"
#include "object.h"
#include "object_func.h"
#include "param.h"
#include "style.h"
#include "ticks.h"
#include "window.h"

#define  DEFAULT_MAJOR_TICKS	5
#define  DEFAULT_MINOR_TICKS	20

static Widget object_popup = (Widget) NULL;
static Widget object_form;

static Widget color_field;
static Widget major_field;
static Widget minor_field;

static Textfield_item textfield_items1[] =
{
    { "color: ", default_color, NO_CALLBACK, NO_DATA, &color_field }
};

static int ntexts1 = ARRAY_SIZE(textfield_items1);

static Textfield_item textfield_items2[] =
{
    { "# major ticks: ", major_ticks, NO_CALLBACK, NO_DATA, &major_field },
    { "# minor ticks: ", minor_ticks, NO_CALLBACK, NO_DATA, &minor_field }
};

static int ntexts2 = ARRAY_SIZE(textfield_items2);

static Widget object_boxes[NGLOBAL_OBJECTS];
static Checkbox_item object_items[NGLOBAL_OBJECTS];

static int nobject_types = ARRAY_SIZE(object_boxes);

#define  NVISIBILITY_TYPES  2

static Widget visibility_boxes[NVISIBILITY_TYPES];
static Radiobox_item visibility_items[] =
{
    { "visible", NO_CALLBACK, NO_DATA, visibility_boxes + VISIBILITY_ON },
    { "invisible", NO_CALLBACK, NO_DATA, visibility_boxes + VISIBILITY_OFF }
};

static int visibility_type = VISIBILITY_ON;
static int nvisibility_types = ARRAY_SIZE(visibility_boxes);

void update_object_params()
{
    if (object_popup)
    {
	get_textfields(textfield_items1, ntexts1);
	get_textfields(textfield_items2, ntexts2);
	visibility_type = get_radio_state(visibility_boxes, nvisibility_types);

	sprintf(default_visible, "%d", visibility_type);
    }
    else
    {
	if (!(*major_ticks))
	    sprintf(major_ticks, "%d", DEFAULT_MAJOR_TICKS);

	if (!(*minor_ticks))
	    sprintf(minor_ticks, "%d", DEFAULT_MINOR_TICKS);

	if (*default_visible)
	    visibility_type = atoi(default_visible);
    }
}

Status objects_apply(int *ndata_sets, Data_info **data_info,
				Global_info *global_info, String error_msg)
{
    update_object_params();

    return  objects_apply_func(ndata_sets, data_info, global_info, error_msg);
}

static void object_command(int object)
{
    object_object_func(object);
}

static void object_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int object = (int) data;

    object_command(object);
}

Status object_object_command(String value, Generic_ptr data, String error_msg)
{
    int object;

    if (!object_name_exists(NGLOBAL_OBJECTS, value, &object))
    {
	sprintf(error_msg, "object name '%s' unknown", value);
	return  ERROR;
    }

    object_command(object);

    return  OK;
}

static void apply_command()
{
    do_display_drawing();
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    apply_command();
}

Status object_apply_command(String value, Generic_ptr data, String error_msg)
{
    apply_command();

    return  OK;
}

static void get_command()
{
    object_get_func();

    visibility_type = atoi(default_visible);

    if (object_popup)
    {
	set_textfields(textfield_items1, ntexts1);
	set_radio_state(visibility_boxes, nvisibility_types, visibility_type);
    }
}

static void get_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    get_command();
}

Status object_get_command(String value, Generic_ptr data, String error_msg)
{
    get_command();

    return  OK;
}

static void set_command()
{
    update_object_params();

    object_set_func();
}

static void set_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    set_command();
}

Status object_set_command(String value, Generic_ptr data, String error_msg)
{
    set_command();

    return  OK;
}

static void color_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    String name = (String) data;
    strcpy(default_color, name);

    set_textfields(textfield_items1, 1);
}

static void create_object_popup(Widget parent)
{
    int i, objects_set;
    Widget buttons, radio, texts, separator, check, dropdown;
    static Button_item button_items[] =
    {
	{ "apply",	apply_callback,		NO_DATA },
	{ "get",	get_callback,		NO_DATA },
	{ "set",	set_callback,		NO_DATA },
#define  DISMISS_BUTTON  3
	{ "dismiss",	dismiss_callback,	NO_DATA },
	{ "help",	help_callback,		(Callback_ptr) object_help }
    };
    static int nbuttons = ARRAY_SIZE(button_items);
    static Dropdown_list_info dropdown_list_info;

    update_object_params();

    object_popup = create_popup(parent, "Default Properties");
    CHECK_WIDGET_WARNING(object_popup);

    object_form = create_form(object_popup);
    CHECK_WIDGET_DESTROY_WARNING(object_form, object_popup);

    for (i = 0; i < nobject_types; i++)
    {
	object_items[i].label = object_labels[i];
	object_items[i].data = (Generic_ptr) i;
	object_items[i].box = object_boxes + i;
	object_items[i].callback = object_callback;
    }

    objects_set = object_objects_set();
    check = create_checkbox(object_form, object_items, nobject_types,
                                                        objects_set, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(check, object_popup);
    attachments(check, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(object_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, object_popup);
    attachments(separator, check, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    dropdown_list_info.label = (char *) NULL;
    dropdown_list_info.nitems = get_ncolors();
    dropdown_list_info.items = get_color_names();
    dropdown_list_info.callback_names = TRUE;
    dropdown_list_info.callback = color_callback;

    dropdown = create_dropdown_list(object_form, &dropdown_list_info);
    CHECK_WIDGET_DESTROY_WARNING(dropdown, object_popup);
    attachments(dropdown, separator, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    texts = create_textfields(object_form, textfield_items1, ntexts1);
    CHECK_WIDGET_DESTROY_WARNING(texts, object_popup);
    attachments(texts, dropdown, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(object_form, visibility_items, nvisibility_types,
					visibility_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, object_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(object_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, object_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    texts = create_textfields(object_form, textfield_items2, ntexts2);
    CHECK_WIDGET_DESTROY_WARNING(texts, object_popup);
    attachments(texts, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(object_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, object_popup);
    attachments(separator, texts, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    button_items[DISMISS_BUTTON].data = (Callback_ptr) object_form;
    buttons = create_horizontal_buttons(object_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, object_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    manage_widget(object_form);
}

void object_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!object_popup)
        create_object_popup(parent);

    if (object_popup)
	popup(object_form);
}

Status object_popup_command(String value, Generic_ptr data, String error_msg)
{
    object_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
