#include "extract_func.h"

#include "block.h"
#include "data.h"
#include "extract.h"
#include "param.h"
#include "prop_func.h"
#include "ref.h"
#include "rowcol_func.h"
#include "save_func.h"

#define  DEFAULT_DATA_SCALE	1.0

static int subset_type = SUBSET_ALL;
static int ref_type = REF_POINTS;

static Extract_param extract_param =
{
    REF_POINTS, SUBSET_ALL, param_file, plane_dirns, plane_thick,
    plane_point, first_points, last_points, step_points
};

static void update_extract_data()
{
    if (*plane_subset)
	subset_type = atoi(plane_subset);

    if (*plane_ref)
	ref_type = atoi(plane_ref);

    if (!*data_scale)
	sprintf(data_scale, "%3.2f", DEFAULT_DATA_SCALE);
}

Status extract_load_func(int *p_data_set, Timer_funcs *timer_funcs,
					YesNo_func func, String error_msg)
{
    int i, j, data_set, nwords, /*thickness,*/ *dim_extr, *first, *last, *step;
    float *plane_data, scale/*, t*/;
    Status status;
    Ref_info *ref_info;
    Size_info size_info;
    File_info file_info;
    Extract_info extract_info;
    Store_info store_info;
    Param_info param_info;

    *p_data_set = -1;

    STRIP_LEADING_SPACE(plane_name);
    STRIP_TRAILING_SPACE(plane_name);

    if (data_name_exists(plane_name, &data_set))
    {
        if ((*func)("Plane name exists, overwrite?",
                                        "Yes", "No", (String) NULL) == NO)
            return  OK;
    }

    *p_data_set = data_set;

    update_extract_data();

    STRIP_LEADING_SPACE(param_file);
    STRIP_TRAILING_SPACE(param_file);

    extract_param.ref_type = ref_type;
    extract_param.subset_type = subset_type;

    if (get_extract_param(&extract_param, &ref_info, &size_info,
		&file_info, &extract_info, &param_info, error_msg) == ERROR)
	return  ERROR;

    dim_extr = extract_info.dim_extr;
    first = extract_info.first;
    last = extract_info.last;
    step = extract_info.step;

    nwords = 1;
    for (i = 0; i < EXTRACT_DIM; i++)
    {
	j = dim_extr[i];
	nwords *= 1 + (last[j] - first[j]) / step[j];
    }

    if (allocate_data_set(data_set, nwords, plane_name, &plane_data) == ERROR)
	RETURN_ERROR_MSG("allocating memory for data");

    if (OPEN_FOR_BINARY_READING(file_info.file, file_info.name))
    {
        sprintf(error_msg, "opening \"%s\" for reading", file_info.name);
	return  ERROR;
    }

    store_info.data = plane_data;

    status = block_process(&size_info, &store_info, &file_info,
			&extract_info, timer_funcs, error_msg);

    fclose(file_info.file);

    if (status != OK)
	return  status;

    scale = atof(data_scale);
    if (scale != DEFAULT_DATA_SCALE)
	SCALE_VECTOR(plane_data, plane_data, scale, nwords);

/*  know below is o.k. from get_extract_param  */
/*
    thickness = atoi(plane_thick);
    if (thickness > 1)
    {
	t = 1.0 / thickness;
	scale = 1;
	for (i = 0; i < size_info.ndim - EXTRACT_DIM; i++)
	    scale *= t;

	SCALE_VECTOR(plane_data, plane_data, scale, nwords);
    }
*/

    /* calculate largest, do 2D referencing, etc. */
    enrol_data_set(data_set, &size_info, ref_info, &extract_info, &param_info);
    register_property_set_func(data_set);
    register_rowcol_set_func(data_set);
    register_save_set_func(data_set);

    return  OK;
}
