#ifndef _incl_draw
#define _incl_draw

#include "macros.h"
#include "types.h"
#include "consts.h"

#include "data.h"
#include "object.h"

typedef struct
{
    int nlevels;
    float *levels;
    int ref_type;
    float lower[DISPLAY_DIM];
    float upper[DISPLAY_DIM];
    int ndata_sets;
    Data_info *data_info;
    Global_info global_info;
    int fold_type[DISPLAY_DIM];
    int flip_type[DISPLAY_DIM];
}   Draw_info;

typedef struct
{
    int x, y;
    int w, h;
    int ref_type;
    float scale;
    float lower[DISPLAY_DIM];
    float upper[DISPLAY_DIM];
    int ndata_sets;
    Data_info *data_info;
    Global_info global_info;
}   Draw_rowcol_info;

extern void free_draw_memory
	();

extern Status do_drawing
	(Draw_info *draw_info, Draw_funcs *draw_funcs,
				Timer_funcs *timer_funcs, String error_msg);

extern void draw_rows_and_cols
	(Draw_rowcol_info *rowcol_info, Draw_funcs *draw_funcs);

#endif /* _incl_draw */
