#include "data_popup.h"

#include "data.hlp"

#include "callback.h"
#include "data.h"
#include "data_func.h"
#include "display_popup.h"
#include "object.h"
#include "object_popup.h"
#include "prop_popup.h"
#include "save_popup.h"
#include "window.h"

#define  VISIBLE_ITEMS  10

static Widget data_popup = (Widget) NULL;
static Widget data_form;
static Widget data_list;

static int ndata_sets = 0;

void update_data_params()
{
}

void remove_data_set(int data_set)
{
    remove_data_set_func(data_set);

    if (data_set < ndata_sets)
    {
	if (data_list)
	    delete_from_list(data_list, data_set+1);

	ndata_sets--;
    }

    remove_property_set(data_set);
    remove_rowcol_set(data_set);
    remove_save_set(data_set);
}

void register_data_set(int data_set, String name)
{
    if (data_set >= ndata_sets)
    {
	if (data_list)
	{
	    insert_in_list(data_list, name, 0);
	    select_from_list(data_list, data_set+1, FALSE);
	}

	ndata_sets++;
    }

    register_data_set_func(data_set, name);
}

static void delete_command()
{
    int i;

    for (i = ndata_sets-1; i >= 0; i--)
    {
	if (get_data_on_off(i) == VISIBILITY_ON)
    	    remove_data_set(i);
    }
}

static void delete_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    delete_command();
}

Status data_delete_command(String value, Generic_ptr data, String error_msg)
{
    delete_command();

    return  OK;
}

static void check_on_off(int n, int on_off1, int on_off2)
{
    if (on_off1 == on_off2)
	return;

    if (data_list)
    {
	if (on_off2 == VISIBILITY_ON)
	    select_from_list(data_list, n+1, FALSE);
	else
	    deselect_from_list(data_list, n+1);
    }
}

static void next_command()
{
    int i, on_off;

    if (ndata_sets == 0)
	return;

    on_off = get_data_on_off(ndata_sets-1);

    for (i = ndata_sets-1; i > 0; i--)
	check_on_off(i, get_data_on_off(i), get_data_on_off(i-1));

    check_on_off(0, get_data_on_off(0), on_off);

    data_next_func();

    do_display_drawing();
}

static void next_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    next_command();
}

Status data_next_command(String value, Generic_ptr data, String error_msg)
{
    next_command();

    return  OK;
}

static void previous_command()
{
    int i, on_off;

    if (ndata_sets == 0)
	return;

    on_off = get_data_on_off(0);

    for (i = 0; i < (ndata_sets-1); i++)
	check_on_off(i, get_data_on_off(i), get_data_on_off(i+1));

    check_on_off(ndata_sets-1, get_data_on_off(ndata_sets-1), on_off);

    data_previous_func();

    do_display_drawing();
}

static void previous_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    previous_command();
}

Status data_previous_command(String value, Generic_ptr data, String error_msg)
{
    previous_command();

    return  OK;
}

static void select_command(int data_set)
{
    data_select_func(data_set);
}

static void select_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int data_set;

    data_set = list_position(cbs);
    select_command(data_set);
}

Status data_select_command(String value, Generic_ptr data, String error_msg)
{
    int data_set;

    if (!data_name_exists(value, &data_set))
    {
	sprintf(error_msg, "data name '%s' unknown", value);
	return  ERROR;
    }

    select_command(data_set);

    return  OK;
}

static void apply_command()
{
    do_display_drawing();
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    apply_command();
}

Status data_apply_command(String value, Generic_ptr data, String error_msg)
{
    apply_command();

    return  OK;
}

static void all_on_command()
{
    int i;

    if (data_list)
    {
	for (i = 0; i < ndata_sets; i++)
	{
	    if (get_data_on_off(i) == VISIBILITY_OFF)
		select_from_list(data_list, i+1, FALSE);
	}
    }

    data_all_on_func();

    do_display_drawing();
}

static void all_on_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    all_on_command();
}

Status data_all_on_command(String value, Generic_ptr data, String error_msg)
{
    all_on_command();

    return  OK;
}

static void all_off_command()
{
    int i;

    if (data_list)
    {
	for (i = 0; i < ndata_sets; i++)
	{
	    if (get_data_on_off(i) == VISIBILITY_ON)
		deselect_from_list(data_list, i+1);
	}
    }

    data_all_off_func();

    do_display_drawing();
}

static void all_off_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    all_off_command();
}

Status data_all_off_command(String value, Generic_ptr data, String error_msg)
{
    all_off_command();

    return  OK;
}

static void defaults_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    object_popup_callback(get_topshell(), data, cbs);
}

static void properties_callback(Widget widget, Callback_ptr data,
                                                        Callback_ptr cbs)
{
    property_popup_callback(get_topshell(), data, cbs);
}

static void saving_callback(Widget widget, Callback_ptr data,
                                                        Callback_ptr cbs)
{
    save_popup_callback(get_topshell(), data, cbs);
}

static String data_string_func(int n, Generic_ptr data)
{
    return  get_data_name(n);
}

static Widget create_data_list_form(Widget parent)
{
    Scrolled_list_info data_list_info;
    Widget label, buttons, form;
    static Button_item button_items[] =
    {
	{ "delete",	delete_callback,	NO_DATA },
	{ "next",	next_callback,		NO_DATA },
	{ "previous",	previous_callback,	NO_DATA },
	{ "all on",	all_on_callback,	NO_DATA },
	{ "all off",	all_off_callback,	NO_DATA }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    form = create_form(parent);
    CHECK_WIDGET(form);

    label = create_label(form, "data sets:");
    CHECK_WIDGET_DESTROY(label, form);
    attachments(label, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    buttons = create_vertical_buttons(form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY(buttons, form);
    attachments(buttons, label, NO_ATTACH, FORM_ATTACH, NO_ATTACH);
    offsets(buttons, 2*UNIT_OFFSET, NO_OFFSET, 2*UNIT_OFFSET, NO_OFFSET);

    data_list_info.selection_policy = MULTIPLE_SELECT;
    data_list_info.nitems = ndata_sets;
    data_list_info.func = data_string_func;
    data_list_info.nvisible_items = VISIBLE_ITEMS;
    data_list_info.callback = select_callback;

    data_list = create_scrolled_list(form, &data_list_info);
    CHECK_WIDGET_DESTROY(data_list, form);
    attachments(WIDGET_PARENT(data_list),
				label, FORM_ATTACH, buttons, FORM_ATTACH);

    offsets(WIDGET_PARENT(data_list),
			UNIT_OFFSET, UNIT_OFFSET, 2*UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(form);

    return  form;
}

static void initial_selection()
{
    int i, on_off;

    for (i = 0; i < ndata_sets; i++)
    {
	on_off = get_data_on_off(i);

	if (on_off == VISIBILITY_ON)
	    select_from_list(data_list, i+1, FALSE);
    }

}

static void create_data_popup(Widget parent)
{
    Widget buttons, buttons2, separator, form;
    static Button_item button_items[] =
    {
	{ "saving",	saving_callback,	NO_DATA },
	{ "defaults",	defaults_callback,	NO_DATA },
	{ "properties",	properties_callback,	NO_DATA }
    };
    static int nbuttons = ARRAY_SIZE(button_items);
    Apply_dismiss_help_info adh_info;
    char apply_label[] = "apply";

    update_data_params();

    data_popup = create_popup(parent, "Data Sets");
    CHECK_WIDGET_WARNING(data_popup);

    data_form = create_form(data_popup);
    CHECK_WIDGET_DESTROY_WARNING(data_form, data_popup);

    form = create_data_list_form(data_form);
    CHECK_WIDGET_DESTROY_WARNING(form, data_popup);

    separator = create_separator(data_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, data_popup);

    buttons = create_horizontal_buttons(data_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, data_popup);

    adh_info.apply_label = apply_label;
    adh_info.apply_callback = apply_callback;
    adh_info.dismiss_form = data_form;
    adh_info.help_message = data_help;

    buttons2 = create_apply_dismiss_help(data_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons2, data_popup);

    attachments(buttons2, NO_ATTACH, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    attachments(buttons, NO_ATTACH, buttons2, FORM_ATTACH, FORM_ATTACH);
    attachments(separator, NO_ATTACH, buttons, FORM_ATTACH, FORM_ATTACH);
    attachments(form, FORM_ATTACH, separator, FORM_ATTACH, FORM_ATTACH);

    offsets(buttons, UNIT_OFFSET, NO_OFFSET, UNIT_OFFSET, UNIT_OFFSET);
    offsets(buttons2, UNIT_OFFSET, NO_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(data_form);

    initial_selection();
}

void data_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!data_popup)
	create_data_popup(parent);

    if (data_popup)
	popup(data_form);
}

Status data_popup_command(String value, Generic_ptr data, String error_msg)
{
    data_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
