#include "baseline_func.h"

#include "param.h"
#include "baseline.h"
#include "slice.h"

static int baseline_type = NO_BASELINE;
static int base_fit_type = CONST_BASELINE;

#define  HALF_WIDTH		4
#define  DEGREE_ORDER		0

#define  SET_VALUE(string, value) \
	 {   sprintf(string, "%d", value);   }

#define  SET_VALUE_OR_DEFAULT(string, value) \
	 {   if (!(*(string)))  SET_VALUE(string, value);   }

void set_baseline_params()
{
    SET_VALUE_OR_DEFAULT(half_width, HALF_WIDTH);
    SET_VALUE_OR_DEFAULT(degree_order, DEGREE_ORDER);
}

static void update_baseline_data()
{
    if (*baseline_used)
	baseline_type = atoi(baseline_used);

    if (*base_fit_used)
	base_fit_type = atoi(base_fit_used);
}

static void get_baseline_file()
{
    STRIP_LEADING_SPACE(baseline_file);
    STRIP_TRAILING_SPACE(baseline_file);
}

Status baseline_apply_func(Slice_info *info, String error_msg)
{
    Baseline_info baseline_info;

    update_baseline_data();

    if (baseline_type == NO_BASELINE)
	return  OK;

    baseline_info.baseline_type = baseline_type;
    baseline_info.base_fit_type = base_fit_type;
    baseline_info.half_width = atoi(half_width);
    baseline_info.degree_order = atoi(degree_order);

    baseline_info.npoints = info->npoints;
    baseline_info.npoints_orig = info->npoints_orig;
    baseline_info.first = info->first;
    baseline_info.step = info->step;
    baseline_info.data = info->data;

    CHECK_STATUS(do_baseline(&baseline_info, error_msg));

    return  OK;
}

/*  with next/previous functions cannot actually do baseline  */
/*  because before that have to start the entire process over again */

void baseline_half_width_next_func()
{
    sprintf(half_width, "%d", atoi(half_width)+1);
}

void baseline_half_width_previous_func()
{
    sprintf(half_width, "%d", atoi(half_width)-1);
}

void baseline_degree_order_next_func()
{
    sprintf(degree_order, "%d", atoi(degree_order)+1);
}

void baseline_degree_order_previous_func()
{
    sprintf(degree_order, "%d", atoi(degree_order)-1);
}

Status baseline_load_func(String error_msg)
{
    get_baseline_file();

    CHECK_STATUS(load_baseline_points(baseline_file, error_msg));

    return  OK;
}

Status baseline_save_func(String error_msg)
{
    get_baseline_file();

    if (!*baseline_file)
	RETURN_ERROR_MSG("no baseline file specified");

    CHECK_STATUS(save_baseline_points(baseline_file, error_msg));

    return  OK;
}

void baseline_clear_func()
{
    clear_baseline_points();
}
