#ifndef _incl_baseline
#define _incl_baseline

#include "macros.h"
#include "types.h"

#define  NO_BASELINE		0
#define  AUTO_BASELINE		1
#define  PICK_BASELINE		2
#define  NBASELINE_TYPES	3

#define  CONST_BASELINE		0
#define  POLY_BASELINE		1
#define  TRIG_BASELINE		2
#define  NBASE_FIT_TYPES	3

typedef struct
{
    int baseline_type;
    int base_fit_type;
    int half_width;
    int degree_order;
    int npoints;
    int npoints_orig;
    int first;
    int step;
    float *data;
}   Baseline_info;

extern Status insert_baseline_point
	(float point, int n, String error_msg);

extern Status delete_baseline_point
	(float point, int n, String error_msg);

extern Status do_baseline
	(Baseline_info *info, String error_msg);

extern void draw_baseline
	(Draw_funcs *funcs, int n, float *d, float *lower, float *upper);

extern Status load_baseline_points
	(String file, String error_msg);

extern Status save_baseline_points
	(String file, String error_msg);

extern void clear_baseline_points
	();

#endif /* _incl_baseline */
