#ifndef _incl_base
#define _incl_base

#include "macros.h"
#include "types.h"

extern Status alloc_baseline
	(int npoints, int order);

extern void range_base_points
	(int first, int last, int nbaseline_in, int *baseline_in,
				int *nbaseline_out, int *baseline_out);

extern Status read_base_points
	(String file, int npoints, int *nbaseline,
                                        int *baseline, String error_msg);

extern Status read_base_values
	(String file, int npoints, float *base_values, String error_msg);

extern Bool find_baseline
	(int n, int w, float *avg_min_chisq, int *nchisq,
			float *data, int *nbaseline, int **baseline);

extern void fit_const_baseline
	(int npoints, float *data, int nbaseline, int *baseline);

extern void fit_poly_baseline
	(int npoints, int order, float *data, int nbaseline, int *baseline);

extern void fit_trig_baseline
	(int npoints, int npoints_orig, int order, float *data,
					int nbaseline, int *baseline);


#endif /* _incl_base */
