#include "text_popup.h"

#include "text.hlp"

#include "callback.h"
#include "display_popup.h"
#include "param.h"
#include "text.h"
#include "window.h"

static Widget text_popup = (Widget) NULL;
static Widget text_form;

static int ntexts;
static Textfield_item *text_text;
static Widget *text_field;
static Param_value *text_param;

static void set_text_fields()
{
    set_textfields(text_text, ntexts);
}

static void set_text_defaults()
{
    int i;

    for (i = 0; i < ntexts; i++)
	strcpy(text_param[i], text_default(i));
}

void update_text_params()
{
    if (text_popup)
	get_textfields(text_text, ntexts);
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int i;
    Line error_msg;

    update_text_params();

    for (i = 0; i < ntexts; i++)
	if (change_text(i, text_param[i], error_msg) == ERROR)
	    ERROR_AND_RETURN(error_msg);

    if (do_display_drawing(0, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

#define  SCROLLED_WIDTH		560
#define  SCROLLED_HEIGHT	460
#define  SCROLL_TEXTS		10

static void create_text_popup(Widget parent)
{
    int i;
    Widget buttons, separator, text, sw, sw_form;
    Scrolled_window_info scrolled_info;
    Bool scrolls;
    Apply_dismiss_help_info adh_info;
    char apply_label[] = "apply";

    update_text_params();

    text_popup = create_popup(parent, "Texts");
    CHECK_WIDGET_WARNING(text_popup);

    text_form = create_form(text_popup);
    CHECK_WIDGET_DESTROY_WARNING(text_form, text_popup);

    scrolls = (ntexts > SCROLL_TEXTS)  ?  TRUE  :  FALSE;

    if (scrolls)
    {
	scrolled_info.width = SCROLLED_WIDTH;
	scrolled_info.height = SCROLLED_HEIGHT;
	sw = create_scrolled_window(text_form, &scrolled_info);
	CHECK_WIDGET_DESTROY_WARNING(sw, text_popup);
	attachments(sw, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

	sw_form = create_form(sw);
	CHECK_WIDGET_DESTROY_WARNING(sw_form, text_popup);
	attachments(sw_form, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH,
								FORM_ATTACH);
    }
    else
    {
	sw_form = text_form;
    }

    separator = FORM_ATTACH;

    set_text_defaults();

    for (i = 0; i < ntexts; i++)
    {
	text_text[i].label = text_label(i);

	text = create_textfields(sw_form, text_text+i, 1);
	CHECK_WIDGET_DESTROY_WARNING(text, text_popup);
	attachments(text, separator, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

	separator = create_separator(sw_form);
	CHECK_WIDGET_DESTROY_WARNING(separator, text_popup);
	attachments(separator, text, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
    }

    adh_info.apply_label = apply_label;
    adh_info.apply_callback = apply_callback;
    adh_info.dismiss_form = text_form;
    adh_info.help_message = text_help;

    buttons = create_apply_dismiss_help(text_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons, text_popup);

    if (scrolls)
	attachments(buttons, sw, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    else
	attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);

    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    set_text_fields();

    if (scrolls)
    {
	manage_widget(sw_form);
	manage_widget(sw);
    }

    manage_widget(text_form);
}

static Status alloc_text_popup_memory()
{
    int i;

    if (ntexts == 0)
	return  OK;

    MALLOC(text_text, Textfield_item, ntexts);
    MALLOC(text_field, Widget, ntexts);
    MALLOC(text_param, Param_value, ntexts);

    for (i = 0; i < ntexts; i++)
    {
	text_text[i].value = text_param[i];
	text_text[i].callback = (Callback_proc) NULL;
	text_text[i].data = (Callback_ptr) NULL;
	text_text[i].field = &text_field[i];
    }

    return  OK;
}

void text_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!text_popup)
    {
	ntexts = number_texts();
	if (alloc_text_popup_memory() == ERROR)
	    ERROR_AND_EXIT("allocating text popup memory");

	create_text_popup(parent);
    }

    if (text_popup)
	popup(text_form);
}
