#include "text.h"

#include "parser.h"
#include "script.h"

#define  PARSER_TEXT		(1 << 10)

#define  NTEXTS_ALLOC		20

#define  TEXT_VALUE		1
#define  TEXT_LABEL		2

#define  TEXT_ARGS		3

typedef struct
{
    Parser_store *store[TEXT_ARGS];
}   Text;

static int ntexts = 0;
static int ntexts_alloc = 0;
static Text *texts;

static void free_text_memory()
{
    if (ntexts_alloc > 0)
    {
	FREE(texts, Text);
	ntexts = ntexts_alloc = 0;
    }
}

static Status alloc_text_memory(String error_msg)
{
    int n;

    if (ntexts_alloc == 0)
    {
	sprintf(error_msg, "allocating text memory");

	n = NTEXTS_ALLOC;
	MALLOC(texts, Text, n);
	ntexts_alloc = n;
    }
    else
    {
	sprintf(error_msg, "reallocating text memory");

	n = ntexts_alloc + NTEXTS_ALLOC;
	REALLOC(texts, Text, n);
	ntexts_alloc = n;
    }

    return  OK;
}

Status change_text(int text, String value, String error_msg)
{
    int nalloc;
    String p;
    Text *t;

    t = texts + text;

    nalloc = strlen(value) + 1;
    CHECK_STATUS(check_parser_alloc(t->store[OUTPUT_X], nalloc, error_msg));

    p = (String) (t->store[OUTPUT_X]->data);
    strcpy(p, value);

    return  OK;
}

static Status do_text(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int n;
    String p1, p2;

    if (!first_run)
	return  OK;

    n = store[TEXT_VALUE]->ndata;
    p1 = (String) (store[TEXT_VALUE]->data);

    CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], n, error_msg));
    p2 = (String) (store[OUTPUT_X]->data);

    strcpy(p2, p1);

    return  OK;
}

Status init_text(int nstore, Parser_store **store, String error_msg)
{
    if (ntexts == ntexts_alloc)
	CHECK_STATUS(alloc_text_memory(error_msg));

    if (setup_command(nstore, store, "text", do_text, error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = PARSER_SS | PARSER_TEXT;

    COPY_VECTOR(texts[ntexts].store, store, nstore);

    ntexts++;

    return  OK;
}

int number_texts()
{
    return  ntexts;
}

String text_label(int text)
{
    return  (String) (texts[text].store[TEXT_LABEL]->data);
}

String text_default(int text)
{
    String value;

    value = (String) (texts[text].store[TEXT_VALUE]->data);

    return  value;
}
