#ifndef _incl_script_command
#define _incl_script_command

#include "parser.h"

/* necessary forward reference */

static Status init_include(int nstore, Parser_store **store, String error_msg);

/* header files for the commands */

#include "arith.h"
#include "arrange.h"
#include "assign.h"
#include "avance.h"
#include "baseline.h"
#include "button.h"
#include "complex.h"
#include "convolve.h"
#include "fft.h"
#include "input.h"
#include "lp_first.h"
#include "lp_last.h"
#include "maths.h"
#include "object.h"
#include "phase.h"
#include "plots.h"
#include "slider.h"
#include "text.h"
#include "weight.h"

static int add_parser[] = { PARSER_IF, PARSER_IF, PARSER_IF };
static int array_parser[] = { PARSER_IF, PARSER_IFFREE };
static int avance_parser[] = { PARSER_FCA, PARSER_FCA, PARSER_FRS, PARSER_FRS };
static int avance2_parser[] = { PARSER_FCA, PARSER_FCA, PARSER_FRS,
						PARSER_FRS, PARSER_FRS };
static int avance_phase_parser[] = { PARSER_FCA, PARSER_FCA };
static int base_const_parser[] = { PARSER_FRA, PARSER_FRA, PARSER_IRS };
static int base_const2_parser[] = { PARSER_FRA, PARSER_FRA, PARSER_IRS,
						PARSER_IRS, PARSER_IRS };
static int base_points_parser[] = { PARSER_NONE, PARSER_FRA, PARSER_SS };
static int base_poly_parser[] = { PARSER_FRA, PARSER_FRA, PARSER_IRS,
								PARSER_IRS };
static int base_poly2_parser[] = { PARSER_FRA, PARSER_FRA, PARSER_IRS,
					PARSER_IRS, PARSER_IRS, PARSER_IRS };
static int base_subtract_parser[] = { PARSER_FRA, PARSER_FRA, PARSER_SS };
static int base_subtract2_parser[] = { PARSER_FRA, PARSER_FRA, PARSER_SS,
						PARSER_IRS, PARSER_IRS };
static int base_trig_parser[] = { PARSER_FRA, PARSER_FRA, PARSER_IRS,
								PARSER_IRS };
static int base_trig2_parser[] = { PARSER_FRA, PARSER_FRA, PARSER_IRS,
					PARSER_IRS, PARSER_IRS, PARSER_IRS };
static int button_parser[] = { PARSER_IRS, PARSER_IRS, PARSER_SS };
static int ceiling_parser[] = { PARSER_I, PARSER_F };
static int cft_parser[] = { PARSER_FRA, PARSER_FRA };
static int cftn_parser[] = { PARSER_FRA, PARSER_FRA };
static int color_parser[] = { PARSER_NONE, PARSER_SS };
static int complex_parser[] = { PARSER_CA, PARSER_IFA };
static int complexify_parser[] = { PARSER_CA, PARSER_RA };
static int conjugate_parser[] = { PARSER_CA, PARSER_CA };
static int conv_box_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS };
static int conv_file_parser[] = { PARSER_FA, PARSER_FA, PARSER_SS, PARSER_IRS };
static int conv_gaussian_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS,
								PARSER_FRS };
static int conv_sine_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS };
static int conv_triangle_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS };
static int convolve_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS };
static int cos_parser[] = { PARSER_FR, PARSER_FR };
static int cycle_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS };
static int decay_parser[] = { PARSER_FA, PARSER_FA, PARSER_FRS };
static int decay_sw_parser[] = { PARSER_FA, PARSER_FA, PARSER_FRS, PARSER_FRS };
static int divide_parser[] = { PARSER_IF, PARSER_IF, PARSER_IF };
static int end_base_points_parser[] = { PARSER_NONE };
static int exchange_parser[] = { PARSER_CA, PARSER_CA };
static int exp_parser[] = { PARSER_F, PARSER_F };
static int fft_parser[] = { PARSER_FCA, PARSER_FCA };
static int fftn_parser[] = { PARSER_FCA, PARSER_FCA };
static int floor_parser[] = { PARSER_I, PARSER_F };
static int gaussian_parser[] = { PARSER_FA, PARSER_FA, PARSER_FRS, PARSER_FRS };
static int gaussian_sw_parser[] = { PARSER_FA, PARSER_FA, PARSER_FRS,
						PARSER_FRS, PARSER_FRS };
static int hft_parser[] = { PARSER_FCA, PARSER_FRA };
static int icft_parser[] = { PARSER_FRA, PARSER_FRA };
static int icftn_parser[] = { PARSER_FRA, PARSER_FRA };
static int ifft_parser[] = { PARSER_FCA, PARSER_FCA };
static int ifftn_parser[] = { PARSER_FCA, PARSER_FCA };
static int include_parser[] = { PARSER_NONE, PARSER_SS };
static int inv_cosine_parser[] = { PARSER_FA, PARSER_FA, PARSER_FRS,
								PARSER_FRS };
static int irft_parser[] = { PARSER_FRA, PARSER_FCA };
static int irftn_parser[] = { PARSER_FRA, PARSER_FCA };
static int isft_parser[] = { PARSER_FRA, PARSER_FRA };
static int isftn_parser[] = { PARSER_FRA, PARSER_FRA };
static int lower_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS };
static int lp_first_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS,
					PARSER_IRS, PARSER_IRS, PARSER_FRS };
static int lp_first2_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS,
					PARSER_IRS, PARSER_IRS, PARSER_FRS };
static int lp_last_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS,
					PARSER_IRS, PARSER_IRS, PARSER_FRS };
static int lp_last2_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS,
					PARSER_IRS, PARSER_IRS, PARSER_FRS };
static int magnitude_parser[] = { PARSER_RA, PARSER_IFA };
static int magnitude2_parser[] = { PARSER_RA, PARSER_IFA };
static int mask_ppmm_parser[] = { PARSER_FA, PARSER_FA };
static int mirror_half_parser[] = { PARSER_FCA, PARSER_FCA };
static int mirror_zero_parser[] = { PARSER_FCA, PARSER_FCA };
static int multiply_parser[] = { PARSER_IF, PARSER_IF, PARSER_IF };
static int number_parser[] = { PARSER_RS, PARSER_RS };
static int phase_parser[] = { PARSER_FCA, PARSER_FCA, PARSER_FRS, PARSER_FRS };
static int phase2_parser[] = { PARSER_FCA, PARSER_FCA, PARSER_FRS,
						PARSER_FRS, PARSER_FRS };
static int plot_y_parser[] = { PARSER_NONE, PARSER_FA, PARSER_SS };
static int range_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS, PARSER_IRS };
static int read_par_parser[] = { PARSER_RA, PARSER_RA, PARSER_IRS, PARSER_SS };
static int real_parser[] = { PARSER_RA, PARSER_IFA };
static int reduce_parser[] = { PARSER_RA, PARSER_CA };
static int reverse_parser[] = { PARSER_FA, PARSER_FA };
static int rft_parser[] = { PARSER_FCA, PARSER_FRA };
static int rftn_parser[] = { PARSER_FCA, PARSER_FRA };
static int scale_parser[] = { PARSER_RA, PARSER_RA, PARSER_IRS,
						PARSER_IRS, PARSER_FRS };
static int scale2_parser[] = { PARSER_CA, PARSER_CA, PARSER_IRS, PARSER_IRS,
						PARSER_FRS, PARSER_FRS };
static int set_parser[] = { PARSER_RA, PARSER_RA, PARSER_IRS,
						PARSER_IRS, PARSER_FRS };
static int set2_parser[] = { PARSER_CA, PARSER_CA, PARSER_IRS, PARSER_IRS,
						PARSER_FRS, PARSER_FRS };
static int set_reference_parser[] = { PARSER_NONE, PARSER_FRS, PARSER_FRS,
						PARSER_FRS, PARSER_FRS };
static int sft_parser[] = { PARSER_FRA, PARSER_FRA };
static int sftn_parser[] = { PARSER_FRA, PARSER_FRA };
static int shift_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS };
static int sin_parser[] = { PARSER_FR, PARSER_FR };
static int sinebell_parser[] = { PARSER_FA, PARSER_FA, PARSER_FRS };
static int sinebell2_parser[] = { PARSER_FA, PARSER_FA, PARSER_FRS };
static int sizeof_parser[] = { PARSER_IRS, PARSER_IFA };
static int slider_parser[] = { PARSER_FRS, PARSER_FRS, PARSER_FRS, PARSER_FRS,
								PARSER_SS };
static int step_parser[] = { PARSER_RA, PARSER_FRS, PARSER_FRS, PARSER_FRS };
static int string_parser[] = { PARSER_SS, PARSER_SS };
static int subtract_parser[] = { PARSER_IF, PARSER_IF, PARSER_IF };
static int tan_parser[] = { PARSER_FR, PARSER_FR };
static int text_parser[] = { PARSER_SS, PARSER_SS, PARSER_SS };
static int upper_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS };
static int weight_file_parser[] = { PARSER_FRA, PARSER_FRA, PARSER_SS };
static int x_offset_parser[] = { PARSER_NONE, PARSER_FRS };
static int x_scale_parser[] = { PARSER_NONE, PARSER_FRS };
static int y_offset_parser[] = { PARSER_NONE, PARSER_FRS };
static int y_scale_parser[] = { PARSER_NONE, PARSER_FRS };
static int zerofill_parser[] = { PARSER_FA, PARSER_FA, PARSER_IRS };

static Parser_line script_table[] =
{
    { "add",		3,	add_parser,		init_add },
    { "array",		2,	array_parser,		init_array },
    { "avance",		4,	avance_parser,		init_avance },
    { "avance2",	5,	avance2_parser,		init_avance2 },
    { "avance_phase",	2,	avance_phase_parser,	init_avance_phase },
    { "base_const",	3,	base_const_parser,	init_base_const },
    { "base_const2",	5,	base_const2_parser,	init_base_const2 },
    { "base_points",	3,	base_points_parser,	init_base_points },
    { "base_poly",	4,	base_poly_parser,	init_base_poly },
    { "base_poly2",	6,	base_poly2_parser,	init_base_poly2 },
    { "base_subtract",	4,	base_subtract_parser,	init_base_subtract },
    { "base_subtract2",	4,	base_subtract2_parser,	init_base_subtract2 },
    { "base_trig",	4,	base_trig_parser,	init_base_trig },
    { "base_trig2",	6,	base_trig2_parser,	init_base_trig2 },
    { "button",		3,	button_parser,		init_button },
    { "ceiling",	2,	ceiling_parser,		init_ceiling },
    { "cft",		2,	cft_parser,		init_cft },
    { "cftn",		2,	cftn_parser,		init_cftn },
    { "color",		2,	color_parser,		init_color },
    { "complex",	2,	complex_parser,		init_complex },
    { "complexify",	2,	complexify_parser,	init_complexify },
    { "conjugate",	2,	conjugate_parser,	init_conjugate },
    { "conv_box",	3,	conv_box_parser,	init_conv_box },
    { "conv_file",	4,	conv_file_parser,	init_conv_file },
    { "conv_gaussian",	4,	conv_gaussian_parser,	init_conv_gaussian },
    { "conv_sine",	3,	conv_sine_parser,	init_conv_sine },
    { "conv_triangle",	3,	conv_triangle_parser,	init_conv_triangle },
    { "convolve",	3,	convolve_parser,	init_convolve },
    { "cos",		2,	cos_parser,		init_cos },
    { "cycle",		3,	cycle_parser,		init_cycle },
    { "decay",		3,	decay_parser,		init_decay },
    { "decay_sw",	4,	decay_sw_parser,	init_decay_sw },
    { "divide",		3,	divide_parser,		init_divide },
    { "end_base_points",1,	end_base_points_parser,	init_end_base_points },
    { "exchange",	2,	exchange_parser,	init_exchange },
    { "exp",		2,	exp_parser,		init_exp },
    { "fft",		2,	fft_parser,		init_fft },
    { "fftn",		2,	fftn_parser,		init_fftn },
    { "floor",		2,	floor_parser,		init_floor },
    { "gaussian",	4,	gaussian_parser,	init_gaussian },
    { "gaussian_sw",	5,	gaussian_sw_parser,	init_gaussian_sw },
    { "hft",		2,	hft_parser,		init_hft },
    { "icft",		2,	icft_parser,		init_icft },
    { "icftn",		2,	icftn_parser,		init_icftn },
    { "ifft",		2,	ifft_parser,		init_ifft },
    { "ifftn",		2,	ifftn_parser,		init_ifftn },
    { "include",	2,	include_parser,		init_include },
    { "inv_cosine",	4,	inv_cosine_parser,	init_inv_cosine },
    { "irft",		2,	irft_parser,		init_irft },
    { "irftn",		2,	irftn_parser,		init_irftn },
    { "isft",		2,	isft_parser,		init_isft },
    { "isftn",		2,	isftn_parser,		init_isftn },
    { "lower",		3,	lower_parser,		init_lower },
    { "lp_first",	6,	lp_first_parser,	init_lp_first },
    { "lp_first2",	6,	lp_first2_parser,	init_lp_first2 },
    { "lp_last",	6,	lp_last_parser,		init_lp_last },
    { "lp_last2",	6,	lp_last2_parser,	init_lp_last2 },
    { "magnitude",	2,	magnitude_parser,	init_magnitude },
    { "magnitude2",	2,	magnitude2_parser,	init_magnitude2 },
    { "mask_ppmm",	2,	mask_ppmm_parser,	init_mask_ppmm },
    { "mirror_half",	2,	mirror_half_parser,	init_mirror_half },
    { "mirror_zero",	2,	mirror_zero_parser,	init_mirror_zero },
    { "multiply",	3,	multiply_parser,	init_multiply },
    { "number",		2,	number_parser,		init_number },
    { "phase",		4,	phase_parser,		init_phase },
    { "phase2",		5,	phase2_parser,		init_phase2 },
    { "plot_y",		3,	plot_y_parser,		init_plot_y },
    { "range",		4,	range_parser,		init_range },
    { "read_par",	4,	read_par_parser,	init_read_par },
    { "real",		2,	real_parser,		init_real },
    { "reduce",		2,	reduce_parser,		init_reduce },
    { "reverse",	2,	reverse_parser,		init_reverse },
    { "rft",		2,	rft_parser,		init_rft },
    { "rftn",		2,	rftn_parser,		init_rftn },
    { "scale",		5,	scale_parser,		init_scale },
    { "scale2",		6,	scale2_parser,		init_scale2 },
    { "set",		5,	set_parser,		init_set },
    { "set2",		6,	set2_parser,		init_set2 },
    { "set_reference",	5,	set_reference_parser,	init_set_reference },
    { "sft",		2,	sft_parser,		init_sft },
    { "sftn",		2,	sftn_parser,		init_sftn },
    { "shift",		2,	shift_parser,		init_shift },
    { "sin",		2,	sin_parser,		init_sin },
    { "sinebell",	3,	sinebell_parser,	init_sinebell },
    { "sinebell2",	3,	sinebell2_parser,	init_sinebell2 },
    { "sizeof",		2,	sizeof_parser,		init_sizeof },
    { "slider",		5,	slider_parser,		init_slider },
    { "step",		4,	step_parser,		init_step },
    { "string",		2,	string_parser,		init_string },
    { "subtract",	3,	subtract_parser,	init_subtract },
    { "tan",		2,	tan_parser,		init_tan },
    { "text",		3,	text_parser,		init_text },
    { "upper",		3,	upper_parser,		init_upper },
    { "weight_file",	3,	weight_file_parser,	init_weight_file },
    { "x_offset",	2,	x_offset_parser,	init_x_offset },
    { "x_scale",	2,	x_scale_parser,		init_x_scale },
    { "y_offset",	2,	y_offset_parser,	init_y_offset },
    { "y_scale",	2,	y_scale_parser,		init_y_scale },
    { "zerofill",	3,	zerofill_parser,	init_zerofill },
    { (String) NULL,	0,	(int *) NULL,		no_parser_func }
};

#endif /* _incl_script_command */
