#include "plot1.h"

#include "button_popup.h"
#include "callback.h"
#include "color.h"
#include "data_popup.h"
#include "display_popup.h"
#include "object.h"
#include "object_popup.h"
#include "output_popup.h"
#include "param.h"
#include "prop_popup.h"
#include "region_popup.h"
#include "script.h"
#include "slider_popup.h"
#include "text_popup.h"
#include "window.h"

static Widget topshell;

static void quit_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    YesNo yes_no;

    de_iconify_application();

    yes_no = force_question("Do you want to save the parameters?",
						"Yes", "No", "Cancel");

    if (yes_no != CANCEL)
    {
	if (yes_no == YES)
	{
	    update_data_params();
	    update_display_params();
	    update_object_params();
	    update_output_params();
	    update_region_params();

    	    save_parameters();
	}

	exit(0);
    }
}

static void objects_popup_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    object_popup_callback(widget, data, cbs);
    property_popup_callback(widget, data, cbs);
    data_popup_callback(widget, data, cbs);
}

static void check_early_exit(Widget widget)
{
    if (!widget)
	ERROR_AND_EXIT("could not even create toplevel module");
}

void main(int argc, char **argv)
{
    int nbuttons;
    Widget form, top, middle, bottom;
    Line error_msg;
    Button_item top_items[] =
    {
	{ "display",	display_popup_callback,		NO_DATA },
	{ "region",	region_popup_callback,		NO_DATA },
	{ "objects",	objects_popup_callback,		NO_DATA }
    };
    Button_item middle_items[] =
    {
	{ "sliders",	slider_popup_callback,		NO_DATA },
	{ "buttons",	button_popup_callback,		NO_DATA },
	{ "texts",	text_popup_callback,		NO_DATA }
    };
    Button_item bottom_items[] =
    {
	{ "output",	output_popup_callback,		NO_DATA },
	{ "quit",	quit_callback,			NO_DATA },
	{ "help",	help_callback,		(Callback_ptr) plot1_help }
    };

    printf(product);

    if (help_request(argc, argv, help_table))
	exit (0);

    if (argc != 2)
    {
	sprintf(error_msg, "correct usage: %s <plot1 file>", argv[0]);
	ERROR_AND_EXIT(error_msg);
    }

    topshell = initialize_application("Plot1", &argc, argv);
    check_early_exit(topshell);

    register_shell(topshell);

    if (read_script_file(argv[1], error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);

    initialize_parameters(argv[0]);
    initialize_colors();
    initialize_objects();

    form = create_form(topshell);

    nbuttons = ARRAY_SIZE(top_items);
    top = create_horizontal_buttons(form, top_items, nbuttons);
    check_early_exit(top);
    attachments(top, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(top, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    nbuttons = ARRAY_SIZE(middle_items);
    middle = create_horizontal_buttons(form, middle_items, nbuttons);
    check_early_exit(middle);
    attachments(middle, top, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(middle, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    nbuttons = ARRAY_SIZE(bottom_items);
    bottom = create_horizontal_buttons(form, bottom_items, nbuttons);
    check_early_exit(bottom);
    attachments(bottom, middle, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(bottom, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(form);

    change_delete_protocol(topshell, quit_callback);

    if (do_display_drawing(0, error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);

    application_main_loop();
}
