#ifndef _incl_parser
#define _incl_parser

#include "macros.h"
#include "types.h"

/* below are for data_type and arg_types */

#define  PARSER_NONE		0
#define  PARSER_FREE		(1 << 0)

#define  PARSER_INT		(1 << 1)
#define  PARSER_FLOAT		(1 << 2)
#define  PARSER_STRING		(1 << 3)
#define  PARSER_IFS_MASK	(PARSER_INT | PARSER_FLOAT | PARSER_STRING)

#define  PARSER_REAL		(1 << 4)
#define  PARSER_COMPLEX		(1 << 5)
#define  PARSER_RC_MASK		(PARSER_REAL | PARSER_COMPLEX)

#define  PARSER_SCALAR		(1 << 6)
#define  PARSER_ARRAY		(1 << 7)
#define  PARSER_SA_MASK		(PARSER_SCALAR | PARSER_ARRAY)

/* below are some common combinations */

#define  PARSER_IRS		(PARSER_INT | PARSER_REAL | PARSER_SCALAR)
#define  PARSER_FRS		(PARSER_FLOAT | PARSER_REAL | PARSER_SCALAR)
#define  PARSER_SS		(PARSER_STRING | PARSER_SCALAR)
#define  PARSER_IRA		(PARSER_INT | PARSER_REAL | PARSER_ARRAY)
#define  PARSER_FRA		(PARSER_FLOAT | PARSER_REAL | PARSER_ARRAY)
#define  PARSER_ICA		(PARSER_INT | PARSER_COMPLEX | PARSER_ARRAY)
#define  PARSER_FCA		(PARSER_FLOAT | PARSER_COMPLEX | PARSER_ARRAY)
#define  PARSER_IA		(PARSER_IRA | PARSER_ICA)
#define  PARSER_FA		(PARSER_FRA | PARSER_FCA)
#define  PARSER_I		(PARSER_IA | PARSER_SCALAR)
#define  PARSER_F		(PARSER_FA | PARSER_SCALAR)
#define  PARSER_IR		(PARSER_IRA | PARSER_IRS)
#define  PARSER_FR		(PARSER_FRA | PARSER_FRS)
#define  PARSER_IC		(PARSER_ICA | PARSER_ICS)
#define  PARSER_FC		(PARSER_FCA | PARSER_FCS)
#define  PARSER_IFR		(PARSER_IR | PARSER_FR)
#define  PARSER_IFC		(PARSER_IC | PARSER_FC)
#define  PARSER_R		(PARSER_IR | PARSER_FR)
#define  PARSER_C		(PARSER_IC | PARSER_FC)
#define  PARSER_IF		(PARSER_I | PARSER_F)
#define  PARSER_IFA		(PARSER_IA | PARSER_FA)
#define  PARSER_RA		(PARSER_IRA | PARSER_FRA)
#define  PARSER_CA		(PARSER_ICA | PARSER_FCA)
#define  PARSER_RS		(PARSER_IRS | PARSER_FRS)
#define  PARSER_SSFREE		(PARSER_SS | PARSER_FREE)
#define  PARSER_IFREE		(PARSER_I | PARSER_FREE)
#define  PARSER_FFREE		(PARSER_F | PARSER_FREE)
#define  PARSER_IFFREE		(PARSER_IF | PARSER_FREE)

#define  OUTPUT_X	0
#define  INPUT_X	1

typedef struct
{
    int ndata;
    int nalloc;
    int data_type;
    Generic_ptr data;
}   Parser_store;

typedef struct
{
    String pattern;
    int nargs;
    int *arg_types;
    Status (*func)(int nstore, Parser_store **store, String error_msg);
}   Parser_line;

extern Status no_parser_func
	(int nstore, Parser_store **store, String error_msg);

extern Status init_parser
	(String error_msg);

extern Status parser_line
	(String line, Parser_line *table, Bool all_keys, String error_msg);

extern Status parser_file
	(String file, Parser_line *table, Bool all_keys, String error_msg);

extern Status check_parser_alloc
	(Parser_store *store, int n, String error_msg);

extern void store_type_float
	(Parser_store *store);

extern void store_type_int
	(Parser_store *store);

extern void store_int_to_float
	(Parser_store *store);

extern void store_float_to_int
	(Parser_store *store);

#endif /* _incl_parser */
