#include "object_popup.h"

#include "object.hlp"

#include "callback.h"
#include "color.h"
#include "data.h"
#include "display_popup.h"
#include "object.h"
#include "param.h"
#include "prop_popup.h"
#include "style.h"
#include "ticks.h"
#include "window.h"

static Widget object_popup = (Widget) NULL;
static Widget object_form;

static Widget color_field;
static Widget major_field;
static Widget minor_field;

static Param_value object_color;

static Textfield_item textfield_items1[] =
{
    { "color: ", object_color, NO_CALLBACK, NO_DATA, &color_field }
};

static int ntexts1 = ARRAY_SIZE(textfield_items1);

static Textfield_item textfield_items2[] =
{
    { "# major ticks: ", major_ticks, NO_CALLBACK, NO_DATA, &major_field },
    { "# minor ticks: ", minor_ticks, NO_CALLBACK, NO_DATA, &minor_field }
};

static int ntexts2 = ARRAY_SIZE(textfield_items2);

static Widget object_boxes[NGLOBAL_OBJECTS];
static Radiobox_item object_items[NGLOBAL_OBJECTS];

static int object_type = CROSSHAIR_OBJECT;
static int nobject_types = ARRAY_SIZE(object_boxes);

#define  NVISIBILITY_TYPES  2

static Widget visibility_boxes[NVISIBILITY_TYPES];
static Radiobox_item visibility_items[] =
{
    { "visible", NO_CALLBACK, NO_DATA, visibility_boxes + VISIBILITY_ON },
    { "invisible", NO_CALLBACK, NO_DATA, visibility_boxes + VISIBILITY_OFF }
};

static int visibility_type = VISIBILITY_ON;
static int nvisibility_types = ARRAY_SIZE(visibility_boxes);

typedef struct
{
    String visibility;
    String color;
}   Object_strings;

static Object_strings global_strings[] =
{
    {  cross_visibility,	cross_color  },
    {  x_ruler_visibility,	x_ruler_color  },
    {  y_ruler_visibility,	y_ruler_color  },
    {  x_axis_visibility,	x_axis_color  },
    {  y_axis_visibility,	y_axis_color  }
};

static Global_info *global_info;

static int object_selected[NGLOBAL_OBJECTS];

static String default_colors[] =
{
    "Green", "Green", "Green", "", ""
};

void update_object_params()
{
    int i;
    static Bool first_pass = TRUE;

    global_info = get_global_info();

    if (first_pass)
    {
	first_pass = FALSE;

	for (i = 0; i < NGLOBAL_OBJECTS; i++)
	{
	    if (*(global_strings[i].color))
	    {
		global_info->color[i] =
				get_color_index(global_strings[i].color);
	    }
	    else
	    {
		global_info->color[i] =
				get_color_index(default_colors[i]);
            }

	    if (*(global_strings[i].visibility))
	    {
		global_info->visibility[i] = atoi(global_strings[i].visibility);
	    }
	    else
	    {
		global_info->visibility[i] = VISIBILITY_ON;
	    }
	}
    }

    if (object_popup)
    {
	get_textfields(textfield_items1, ntexts1);
        get_textfields(textfield_items2, ntexts2);
        visibility_type = get_radio_state(visibility_boxes, nvisibility_types);
    }
    else
    {
	if (!*major_ticks)
	    sprintf(major_ticks, "%d", global_info->major_ticks[0]);

	if (!*minor_ticks)
	    sprintf(minor_ticks, "%d", global_info->minor_ticks[0]);
    }
}

Status objects_apply(String error_msg)
{
    update_object_params();
    update_property_params();

    find_ticks(major_ticks, global_info->major_ticks);
    find_ticks(minor_ticks, global_info->minor_ticks);

    return  OK;
}

static void get_object_info()
{
    int object;

    for (object = 0; object < NGLOBAL_OBJECTS; object++)
    {
	if (object_selected[object])
	    break;
    }

    if (object < NGLOBAL_OBJECTS)
    {
	if (global_info->color[object] >= 0)
	    strcpy(object_color, get_color_name(global_info->color[object]));
	else
	    *object_color = 0;

	visibility_type = global_info->visibility[object];

	set_textfields(textfield_items1, ntexts1);
	set_radio_state(visibility_boxes, nvisibility_types, visibility_type);
    }
}

static void set_object_info()
{
    int color, object;

    update_object_params();

    color = get_color_index(object_color);

    for (object = 0; object < NGLOBAL_OBJECTS; object++)
    {
	if (object_selected[object])
	{
	    if (*object_color)
	    {
		global_info->color[object] = color;
		strcpy(global_strings[object].color, object_color);
	    }

	    global_info->visibility[object] = visibility_type;
	    sprintf(global_strings[object].visibility, "%d", visibility_type);
	}
    }
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    if (do_display_drawing(0, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

static void object_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int object = (int) data;

    object_selected[object] = !object_selected[object];
}

static void get_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    get_object_info();
}

static void set_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    set_object_info();
}

static void create_object_popup(Widget parent)
{
    int i;
    Widget buttons, radio, texts, separator, check;
    static Button_item button_items[] =
    {
	{ "apply",	apply_callback,		NO_DATA },
	{ "get",	get_callback,		NO_DATA },
	{ "set",	set_callback,		NO_DATA },
#define  DISMISS_BUTTON  3
	{ "dismiss",	dismiss_callback,	NO_DATA },
	{ "help",	help_callback,		(Callback_ptr) object_help }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    update_object_params();

    object_popup = create_popup(parent, "Default Properties");
    CHECK_WIDGET_WARNING(object_popup);

    object_form = create_form(object_popup);
    CHECK_WIDGET_DESTROY_WARNING(object_form, object_popup);

    for (i = 0; i < nobject_types; i++)
    {
	object_items[i].label = object_labels[i];
	object_items[i].data = (Generic_ptr) i;
	object_items[i].box = object_boxes + i;
	object_items[i].callback = object_callback;
    }

    check = create_checkbox(object_form, object_items, nobject_types,
                                                        object_type, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(check, object_popup);
    attachments(check, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(object_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, object_popup);
    attachments(separator, check, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    texts = create_textfields(object_form, textfield_items1, ntexts1);
    CHECK_WIDGET_DESTROY_WARNING(texts, object_popup);
    attachments(texts, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(object_form, visibility_items, nvisibility_types,
						visibility_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, object_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(object_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, object_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    texts = create_textfields(object_form, textfield_items2, ntexts2);
    CHECK_WIDGET_DESTROY_WARNING(texts, object_popup);
    attachments(texts, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(object_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, object_popup);
    attachments(separator, texts, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    button_items[DISMISS_BUTTON].data = (Callback_ptr) object_form;
    buttons = create_horizontal_buttons(object_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, object_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    set_textfields(textfield_items2, ntexts2);

    manage_widget(object_form);

    for (i = 0; i < NGLOBAL_OBJECTS; i++)
	object_selected[i] = FALSE;
}

void object_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!object_popup)
        create_object_popup(parent);

    if (object_popup)
	popup(object_form);
}
