#ifndef _incl_fitter
#define _incl_fitter

#include "macros.h"
#include "types.h"
#include "consts.h"
#include "defns.h"

/* global parameters */
#define  AMPLITUDE_PARAMETER		0
#define  GLOBAL_PARAMETERS		1

/* parameters for each dimension fitted */
#define  PHASE_PARAMETER		0
#define  DECAY_PARAMETER		1
#define  CENTER_PARAMETER		2
#define  DIMENSION_PARAMETERS		3

extern Status initialize_fit
	(int ndim, int nparams, int *npts_max,
			int group_max, String error_msg);

extern void initialize_fixed_params
	(int ndim, Bool *fixed_phase, float *phase,
			Bool *fixed_decay, float *decay);

extern Bool have_good_fit
	(float *x, float *y, float *w,
		int m, int ndim, int nparams, int ngroup,
		float max_chisq, int *base, int *top, int *cum_points,
		Script **s, int *n1, int *n2,
		Bool *cplx, float *freq_a, float *freq_b,
		int **peak_posns, float scale, Fit_peak **peaks);

extern void calculate_fit
	(int ndim, Bool *complex, Script **scripts, int *npts,
	float *freq_a, float *freq_b, int *peak_posn, Fit_peak *peak);

extern float peak_contribution
	(int ndim, int *point, Fit_peak *peak);
 
#endif /* _incl_fitter */
