/* The following code is a slightly modified version of that found in
   "Data structures, an advanced approach using C" by J. Esakov and
   T. Weiss (Prentice Hall, 1989)                                     */

#include "dbl_list.h"

Status allocate_dbl_node(Dbl_list *p_dbl_list, Generic_ptr data_ptr)
{
    MALLOC(*p_dbl_list, Dbl_node, 1);

    DBL_DATA(*p_dbl_list) = data_ptr;
    DBL_NEXT(*p_dbl_list) = NULL;
    DBL_PREVIOUS(*p_dbl_list) = NULL;

    return  OK;
}
 
void free_dbl_node(Dbl_list *p_dbl_list)
{
    FREE(*p_dbl_list, Dbl_node);
}
 
Status init_dbl_list(Dbl_list *p_dbl_list)
{
    *p_dbl_list = NULL;

    return  OK;
}
 
Bool empty_dbl_list(Dbl_list dbl_list)
{
    return  (dbl_list == NULL) ? TRUE : FALSE;
}
 
Status insert_dbl_list(Dbl_list *p_dbl_list, Generic_ptr data_ptr)
{
    Dbl_list dbl_list;
 
    CHECK_STATUS(allocate_dbl_node(&dbl_list, data_ptr));
 
    DBL_NEXT(dbl_list) = *p_dbl_list;
    if (!empty_dbl_list(*p_dbl_list))
	DBL_PREVIOUS(*p_dbl_list) = dbl_list;

    *p_dbl_list = dbl_list;

    return  OK;
}

Status traverse_dbl_list(Dbl_list dbl_list, Check_func func)
{
    if (empty_dbl_list(dbl_list) == TRUE)  return  OK;
 
    CHECK_STATUS((*func)(DBL_DATA(dbl_list)));
 
    return  traverse_dbl_list(DBL_NEXT(dbl_list), func);
}
 
void destroy_dbl_list(Dbl_list *p_dbl_list, Data_func func)
{
    if (empty_dbl_list(*p_dbl_list) == FALSE)
    {
        destroy_dbl_list(&DBL_NEXT(*p_dbl_list), func);
        if (func != NULL)  (*func)(DBL_DATA(*p_dbl_list));
        free_dbl_node(p_dbl_list);
    }
}
 
void move_dbl_list_to_front(Dbl_list *p_dbl_list, Dbl_list dbl_list)
{
    if (*p_dbl_list == dbl_list)
	return;

    DBL_NEXT(DBL_PREVIOUS(dbl_list)) = DBL_NEXT(dbl_list);
    if (!empty_dbl_list(DBL_NEXT(dbl_list)))
	DBL_PREVIOUS(DBL_NEXT(dbl_list)) = DBL_PREVIOUS(dbl_list);

    DBL_PREVIOUS(dbl_list) = NULL;
    DBL_NEXT(dbl_list) = *p_dbl_list;
    DBL_PREVIOUS(*p_dbl_list) = dbl_list;

    *p_dbl_list = dbl_list;
}
