#include "macros.h"
#include "types.h"

#define  NEXT_STRING		"***"
#define  IGNORE_TEXT		'$'

#define  PARAGRAPH		"<P>"

#define  TITLE_BEGIN		"<TITLE>"
#define  TITLE_END		"</TITLE>"
#define  TITLE_NAME		"<A HREF = \"azara.html\">Azara</A> help: "

#define  PREFORMAT_BEGIN	"<PRE>"
#define  PREFORMAT_END		"</PRE>"

#define  HTML_DIRECTORY		"html"

#define  TAG_CHAR_BEGIN		'<'
#define  TAG_CHAR_END		'>'
#define  TAG_CHAR_ESCAPE	'&'
#define  TAG_CHAR_QUOTE		'"'

#define  TAG_STRING_BEGIN	"&lt"
#define  TAG_STRING_END		"&gt"
#define  TAG_STRING_ESCAPE	"&amp"
#define  TAG_STRING_QUOTE	"&quot"

#define  C_CHAR_ESCAPE		'\\'

#define  INTERNAL_REFERENCE	"IREF"
#define  EXTERNAL_REFERENCE	"EREF"

#define  INTERNAL_REF_BEGIN	"<A HREF = \"#"
#define  INTERNAL_REF_MIDDLE	"\">"
#define  INTERNAL_REF_END	"</A>"

#define  EXTERNAL_REF_BEGIN	"<A HREF = \""
#define  EXTERNAL_REF_MIDDLE	".html\">"
#define  EXTERNAL_REF_END	"</A>"

#define  NAME_BEGIN		"<A NAME = \""
#define  NAME_MIDDLE		"\"><H1>"
#define  NAME_END		"</H1></A>"

#define  ADDRESS_BEGIN		"<ADDRESS>"
#define  ADDRESS_END \
" / W. Boucher / <A HREF=\"mailto:azara@bioc.cam.ac.uk\">azara@bioc.cam.ac.uk</A> </ADDRESS>"

static void print_char(char ch, FILE *fp)
{
    if (ch == TAG_CHAR_BEGIN)
	fprintf(fp, "%s;", TAG_STRING_BEGIN);
    else if (ch == TAG_CHAR_END)
	fprintf(fp, "%s;", TAG_STRING_END);
    else if (ch == TAG_CHAR_ESCAPE)
	fprintf(fp, "%s;", TAG_STRING_ESCAPE);
    else if (ch == TAG_CHAR_QUOTE)
	fprintf(fp, "%s;", TAG_STRING_QUOTE);
    else if (ch != C_CHAR_ESCAPE)
	fputc(ch, fp);
}

static Bool is_punctuation_char(char ch)
{
    if ((ch == '.') || (ch == ',') || (ch == ';')
			|| (ch == '(') || (ch == ')')
			|| (ch == '[') || (ch == ']')
			|| (ch == '{') || (ch == '}'))
	return  TRUE;
    else
	return  FALSE;
}

static char *next_ref_stopper(String string)
{
    char *ptr;

    for (ptr = string; *ptr; ptr++)
    {
        if (isspace(*ptr) ||
		(is_punctuation_char(*ptr) && !isalnum(*(ptr+1))))
			
            return  ptr;
    }

    return  ptr;
}

static void copy_to_string(String string, char *ptr1, char *ptr2)
{
    int n;

    n = (int) (ptr2 - ptr1);
    strncpy(string, ptr1, n);
    string[n] = 0;
}

static char *print_internal_ref(char *ptr1, FILE *fp)
{
    char *ptr2;
    Line line;

    ptr2 = next_ref_stopper(ptr1);
    copy_to_string(line, ptr1, ptr2);

    fprintf(fp, "%s%s%s%s%s", INTERNAL_REF_BEGIN, line, INTERNAL_REF_MIDDLE,
						line, INTERNAL_REF_END);

    return  ptr2;
}

static char *print_external_ref(char *ptr1, FILE *fp, String module)
{
    char *ptr2;
    Line line;

    ptr2 = next_ref_stopper(ptr1);
    copy_to_string(line, ptr1, ptr2);

    fprintf(fp, "%s", EXTERNAL_REF_BEGIN);

    if (!strcmp(line, module))
	fprintf(fp, "../");

    fprintf(fp, "%s%s%s%s", line, EXTERNAL_REF_MIDDLE, line, EXTERNAL_REF_END);

    return  ptr2;
}

static char *print_html(char *ptr1, FILE *fp, String module)
{
    char *ptr2;
    Line line;

    ptr1++;
    if (!(ptr2 = strchr(ptr1, IGNORE_TEXT)))
	return  ptr1;

    copy_to_string(line, ptr1, ptr2);

    ptr2++;
    if (!strncmp(line, INTERNAL_REFERENCE, strlen(INTERNAL_REFERENCE)))
	ptr2 = print_internal_ref(ptr2, fp);
    else if (!strncmp(line, EXTERNAL_REFERENCE, strlen(EXTERNAL_REFERENCE)))
	ptr2 = print_external_ref(ptr2, fp, module);
    else
	fprintf(fp, line);

    return  ptr2;
}

static void print_line(String line, FILE *fp, String module)
{
    char *ptr;
    static Bool have_tab = FALSE;

    if ((*line == '\t') && !have_tab)
    {
	have_tab = TRUE;
	fprintf(fp, PREFORMAT_BEGIN);
    }
    else if ((*line != '\t') && have_tab)
    {
	have_tab = FALSE;
	fprintf(fp, PREFORMAT_END);
    }

    if (*line)
    {
	for (ptr = line; *ptr; ptr++)
	{
	    if (*ptr == IGNORE_TEXT)
	    {
		if (*(ptr+1) == IGNORE_TEXT)
		    print_char(*ptr++, fp);
		else
		    ptr = print_html(ptr, fp, module) - 1;
	    }
	    else
	    {
		print_char(*ptr, fp);
	    }
	}
    }
    else
    {
	fprintf(fp, "%s", PARAGRAPH);
    }

    fprintf(fp, "\n");
}

void main(int argc, char **argv)
{
    char *prefix, *name, *ptr;
    Line input_file, output_file, line, module, error_msg;
    FILE *fp_in, *fp_out;

    if (argc != 2)
    {
	sprintf(error_msg, "correct usage: %s <string>", argv[0]);
	ERROR_AND_EXIT(error_msg);
    }

    prefix = argv[1];
    sprintf(input_file, "%s.txt", prefix);
    sprintf(output_file, "..%c%s%c%s.html",
	DIRECTORY_SYMBOL, HTML_DIRECTORY, DIRECTORY_SYMBOL, prefix);

    strcpy(module, prefix);
    if (!(ptr = strchr(module, DIRECTORY_SYMBOL)))
	ptr = module;
 
    *ptr = 0;

    if (OPEN_FOR_READING(fp_in, input_file))
    {
	sprintf(error_msg, "opening \"%s\" for reading", input_file);
	ERROR_AND_EXIT(error_msg);
    }

    if (OPEN_FOR_WRITING(fp_out, output_file))
    {
	sprintf(error_msg, "opening \"%s\" for writing", output_file);
	ERROR_AND_EXIT(error_msg);
    }

    fprintf(fp_out, "%s%s%s%s\n", TITLE_BEGIN, TITLE_NAME, prefix, TITLE_END);

    while (fgets(line, LINE_SIZE, fp_in))
    {
	STRIP_CARRIAGE_RETURN(line);

	if (!strncmp(NEXT_STRING, line, strlen(NEXT_STRING)))
	{
	    name = line + strlen(NEXT_STRING);
	    fprintf(fp_out, "%s%s%s%s%s\n", NAME_BEGIN, name, NAME_MIDDLE,
							name, NAME_END);
	}
	else
	{
	    print_line(line, fp_out, module);
	}
    }

    fprintf(fp_out, "\n%s%s%s%s%s\n", PARAGRAPH, ADDRESS_BEGIN, TITLE_NAME,
							prefix, ADDRESS_END);

    fclose(fp_in);
    fclose(fp_out);
}
