#include "macros.h"
#include "types.h"

#define  NEXT_STRING  "***"
#define  MAX_NSTRINGS  300
#define  MAX_STRING_LENGTH  40
#define  IGNORE_TEXT  '$'

static void print_line(String line, FILE *fp)
{
    char *ptr;

    for (ptr = line; *ptr; ptr++)
    {
	if (*ptr == IGNORE_TEXT)
	{
	    if (*(ptr+1) == IGNORE_TEXT)
		fputc(*ptr++, fp);
	    else if (!(ptr = strchr(ptr+1, IGNORE_TEXT)))
		return;
	}
	else
	{
	    fputc(*ptr, fp);
	}
    }
}

void main(int argc, char **argv)
{
    int i, count;
    char *prefix, *ptr, *full_prefix;
    Line input_file, output_file, line, incl_name, error_msg, directory;
    char string_list[MAX_NSTRINGS][MAX_STRING_LENGTH];
    FILE *fp_in, *fp_out;
    Bool have_directory;

    if (argc != 2)
    {
	sprintf(error_msg, "correct usage: %s <string>", argv[0]);
	ERROR_AND_EXIT(error_msg);
    }

    prefix = argv[1];

    strcpy(directory, prefix);

    /* below needed for peak_find, peak_fit */
    if (ptr = strchr(directory, '_'))
	*ptr = 0;

    full_prefix = prefix;

    /* below needed for plot2, plot1 */
    if (ptr = strchr(directory, DIRECTORY_SYMBOL))
    {
	*ptr++ = 0;
	prefix = ptr;
	have_directory = TRUE;
    }
    else
    {
	have_directory = FALSE;
    }

    sprintf(input_file, "%s.txt", full_prefix);
    sprintf(output_file, "..%c%s%c%s.hlp",
	DIRECTORY_SYMBOL, directory, DIRECTORY_SYMBOL, prefix);
    sprintf(incl_name, "_incl_%s_hlp", prefix);

    if (OPEN_FOR_READING(fp_in, input_file))
    {
	sprintf(error_msg, "opening \"%s\" for reading", input_file);
	ERROR_AND_EXIT(error_msg);
    }

    if (OPEN_FOR_WRITING(fp_out, output_file))
    {
	sprintf(error_msg, "opening \"%s\" for writing", output_file);
	ERROR_AND_EXIT(error_msg);
    }

    fprintf(fp_out, "#ifndef %s\n", incl_name);
    fprintf(fp_out, "#define %s\n\n", incl_name);

    if (!have_directory)
	fprintf(fp_out, "#include \"help.h\"\n\n");

    count = 0;
    strcpy(string_list[count++], prefix);

    fprintf(fp_out, "static char %s_help[] =\n", prefix);

    while (fgets(line, LINE_SIZE, fp_in))
    {
	STRIP_CARRIAGE_RETURN(line);

	if (!strncmp(NEXT_STRING, line, strlen(NEXT_STRING)))
	{
	    fprintf(fp_out, "\t;\n\n");

	    prefix = line + strlen(NEXT_STRING);
	    strcpy(string_list[count++], prefix);

	    fprintf(fp_out, "static char %s_help[] =\n", prefix);
	}
	else
	{
	    fprintf(fp_out, "\t\"");
	    print_line(line, fp_out);
	    fprintf(fp_out, "\\n\"\n");
	}
    }

    fprintf(fp_out, "\t;\n\n");

    if (!have_directory)
    {
	fprintf(fp_out, "static Help_index help_table[] =\n{\n");

	for (i = 0; i < count; i++)
	    fprintf(fp_out, "\t{ \"%s\", %s_help },\n",
					string_list[i], string_list[i]);

	fprintf(fp_out, "\t{ (String) NULL, (String) NULL }\n};\n\n");
    }

    fprintf(fp_out, "#endif /* %s */\n", incl_name);

    fclose(fp_in);
    fclose(fp_out);
}
