#ifndef _incl_lin_pred
#define _incl_lin_pred

#include "macros.h"
#include "types.h"

/*
    data is real array of size npoints+npred
    on input have npoints of data
    on output have npred further points predicted
    ABS(step) is 1 for real data, 2 for complex data
    step is > 0 for forward and < 0 for backward prediction
    npoles is estimated (maximum) number of poles
    coeffs is real work array of size npoles
    w1 is real work array of size MAX(npoints-1, 2*(npoles+1))
    w2 is real work array of size MAX(npoints-1, 2*npoles)
    w3 is real work array of size 2*(npoles+1)
*/
extern void lin_pred
        (float *data, int npoints, int npred, int step, int npoles,
        float *coeffs, float *w1, float *w2, float *w3);

#endif /* _incl_lin_pred */
