#include "csvd.h"

#include "complex.h"

/* the float args are really complex */
extern int csvdc_(float *x, long *ldx, long *n, long *p,
	float *s, float *e, float *u, long *ldu, float *v,
	long *ldv, float *work, long *job, long *info);

/* complex u[m*n], v[n*n], w[n], t1[n], t2[m] */ 
/* remember factors of 2 because of the float --> complex conversion */
/* uses Fortran (i.e. backwards) index storage for 2D arrays */

Bool csvd(float *u, float *v, float *w, float *t1, float *t2, int m, int n)
{
    long mm = m, nn = n, job = 21, info;

    (void) csvdc_(u, &mm, &mm, &nn, w, t1, u, &mm, v, &nn, t2, &job, &info);

    if (info == 0)
	return  TRUE;
    else
	return  FALSE;
}

void csvd_refine(float *w, float cutoff, int n)
{
    int j;
    float wmin, wmax;

/*  note that w is real  */
    wmax = 0;

    for (j = 0; j < n; j++)
	wmax = MAX(wmax, w[2*j]);

    wmin = cutoff * wmax;

    for (j = 0; j < n; j++)
    {
	if (w[2*j] < wmin)
	    w[2*j] = 0;
    }
}

/* Given a csvd decomposition, csvd_fit calculates the least */
/* squares solution to the linear equation a x = d (d[2*m]). */
/* cutoff (>0 and <1) determines which svd values are signficant. */
/* t[2*n] is used for temporary storage. */
/* uses Fortran (i.e. backwards) index storage for 2D arrays */

void csvd_fit(float *u, float *v, float *w, float *x, float *d,
						float *t, int m, int n)
{
    int i, j, k;
    float winv;
    Complex s, z, r;

    for (j = 0; j < n; j++)
    {
	COMPLEX_ZERO(s);

	if (w[2*j] != 0)
	{
	    for (i = 0; i < m; i++)
	    {
		COMPLEX_SET_P(&r , (Complex *) (u+2*(i+m*j)));
		COMPLEX_CONJ(r);
		COMPLEX_MULTIPLY_P(&z , &r, (Complex *) (d+2*i));
		COMPLEX_ADD(s, s, z);
	    }

	    winv = 1 / w[2*j];
	    COMPLEX_SCALE(s, winv);
	}

	t[2*j] = COMPLEX_REAL(s);
	t[2*j+1] = COMPLEX_IMAG(s);
    }

    for (j = 0; j < n; j++)
    {
	COMPLEX_ZERO(s);

	for (k = 0; k < n; k++)
	{
	    COMPLEX_MULTIPLY_P(&z, (Complex *) (v+2*(j+n*k)), (Complex *) (t+2*k));
	    COMPLEX_ADD(s, s, z);
	}

	x[2*j] = COMPLEX_REAL(s);
	x[2*j+1] = COMPLEX_IMAG(s);
    }
}
